/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SslHandler;
import java.net.SocketAddress;
import java.time.Duration;
import reactor.netty.channel.AbstractChannelMetricsHandler;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.util.annotation.Nullable;

public class ChannelMetricsHandler
extends AbstractChannelMetricsHandler {
    final ChannelMetricsRecorder recorder;

    ChannelMetricsHandler(ChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        super(remoteAddress, onServer);
        this.recorder = recorder;
    }

    @Override
    public ChannelHandler connectMetricsHandler() {
        return new ConnectMetricsHandler(this.recorder());
    }

    @Override
    public ChannelHandler tlsMetricsHandler() {
        return new TlsMetricsHandler(this.recorder, this.remoteAddress);
    }

    @Override
    public ChannelMetricsRecorder recorder() {
        return this.recorder;
    }

    static class TlsMetricsHandler
    extends ChannelInboundHandlerAdapter {
        protected final ChannelMetricsRecorder recorder;
        protected final SocketAddress remoteAddress;
        boolean listenerAdded;

        TlsMetricsHandler(ChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress) {
            this.recorder = recorder;
            this.remoteAddress = remoteAddress;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.addListener(ctx);
            ctx.fireChannelActive();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof SniCompletionEvent) {
                this.addListener(ctx);
            }
            ctx.fireUserEventTriggered(evt);
        }

        protected void recordTlsHandshakeTime(ChannelHandlerContext ctx, long tlsHandshakeTimeStart, String status) {
            this.recorder.recordTlsHandshakeTime(this.remoteAddress != null ? this.remoteAddress : ctx.channel().remoteAddress(), Duration.ofNanos(System.nanoTime() - tlsHandshakeTimeStart), status);
        }

        private void addListener(ChannelHandlerContext ctx) {
            SslHandler sslHandler;
            if (!this.listenerAdded && (sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class)) != null) {
                this.listenerAdded = true;
                long tlsHandshakeTimeStart = System.nanoTime();
                sslHandler.handshakeFuture().addListener(f -> {
                    ctx.pipeline().remove((ChannelHandler)this);
                    this.recordTlsHandshakeTime(ctx, tlsHandshakeTimeStart, f.isSuccess() ? "SUCCESS" : "ERROR");
                });
            }
        }
    }

    static final class ConnectMetricsHandler
    extends ChannelOutboundHandlerAdapter {
        final ChannelMetricsRecorder recorder;

        ConnectMetricsHandler(ChannelMetricsRecorder recorder) {
            this.recorder = recorder;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            long connectTimeStart = System.nanoTime();
            super.connect(ctx, remoteAddress, localAddress, promise);
            promise.addListener(future -> {
                ctx.pipeline().remove((ChannelHandler)this);
                this.recorder.recordConnectTime(remoteAddress, Duration.ofNanos(System.nanoTime() - connectTimeStart), future.isSuccess() ? "SUCCESS" : "ERROR");
            });
        }
    }
}

