/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.jdk;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import org.elasticsearch.nativeaccess.jdk.LinkerHelper;
import org.elasticsearch.nativeaccess.jdk.MemorySegmentUtil;
import org.elasticsearch.nativeaccess.lib.MacCLibrary;

class JdkMacCLibrary
implements MacCLibrary {
    private static final MethodHandle sandbox_init$mh = LinkerHelper.downcallHandle("sandbox_init", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.ADDRESS), new Linker.Option[0]);
    private static final MethodHandle sandbox_free_error$mh = LinkerHelper.downcallHandle("sandbox_free_error", FunctionDescriptor.ofVoid(ValueLayout.ADDRESS), new Linker.Option[0]);

    JdkMacCLibrary() {
    }

    @Override
    public MacCLibrary.ErrorReference newErrorReference() {
        return new JdkErrorReference();
    }

    @Override
    public int sandbox_init(String profile, long flags, MacCLibrary.ErrorReference errorbuf) {
        assert (errorbuf instanceof JdkErrorReference);
        JdkErrorReference jdkErrorbuf = (JdkErrorReference)errorbuf;
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment nativeProfile = MemorySegmentUtil.allocateString(arena, profile);
            int n = sandbox_init$mh.invokeExact(nativeProfile, flags, jdkErrorbuf.segment);
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
    }

    @Override
    public void sandbox_free_error(MacCLibrary.ErrorReference errorbuf) {
        assert (errorbuf instanceof JdkErrorReference);
        JdkErrorReference jdkErrorbuf = (JdkErrorReference)errorbuf;
        try {
            sandbox_free_error$mh.invokeExact(jdkErrorbuf.deref());
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    private static class JdkErrorReference
    implements MacCLibrary.ErrorReference {
        final Arena arena = Arena.ofConfined();
        final MemorySegment segment = this.arena.allocate(ValueLayout.ADDRESS);

        private JdkErrorReference() {
        }

        MemorySegment deref() {
            return this.segment.get(ValueLayout.ADDRESS, 0L);
        }

        public String toString() {
            return this.deref().reinterpret(Long.MAX_VALUE).getUtf8String(0L);
        }
    }
}

