/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference.completion;

import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.inference.InferenceOperator;
import org.elasticsearch.xpack.esql.inference.InferenceService;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRequestIterator;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRunner;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRunnerConfig;
import org.elasticsearch.xpack.esql.inference.completion.CompletionOperatorOutputBuilder;
import org.elasticsearch.xpack.esql.inference.completion.CompletionOperatorRequestIterator;

public class CompletionOperator
extends InferenceOperator {
    private final EvalOperator.ExpressionEvaluator promptEvaluator;

    public CompletionOperator(DriverContext driverContext, BulkInferenceRunner bulkInferenceRunner, String inferenceId, EvalOperator.ExpressionEvaluator promptEvaluator, int maxOutstandingPages) {
        super(driverContext, bulkInferenceRunner, inferenceId, maxOutstandingPages);
        this.promptEvaluator = promptEvaluator;
    }

    protected void doClose() {
        Releasables.close((Releasable)this.promptEvaluator);
    }

    public String toString() {
        return "CompletionOperator[inference_id=[" + this.inferenceId() + "]]";
    }

    @Override
    protected BulkInferenceRequestIterator requests(Page inputPage) {
        return new CompletionOperatorRequestIterator((BytesRefBlock)this.promptEvaluator.eval(inputPage), this.inferenceId());
    }

    @Override
    protected CompletionOperatorOutputBuilder outputBuilder(Page input) {
        BytesRefBlock.Builder outputBlockBuilder = this.blockFactory().newBytesRefBlockBuilder(input.getPositionCount());
        return new CompletionOperatorOutputBuilder(outputBlockBuilder, input);
    }

    public record Factory(InferenceService inferenceService, String inferenceId, EvalOperator.ExpressionEvaluator.Factory promptEvaluatorFactory) implements Operator.OperatorFactory
    {
        public String describe() {
            return "CompletionOperator[inference_id=[" + this.inferenceId + "]]";
        }

        public Operator get(DriverContext driverContext) {
            return new CompletionOperator(driverContext, this.inferenceService.bulkInferenceRunner(), this.inferenceId, this.promptEvaluatorFactory.get(driverContext), BulkInferenceRunnerConfig.DEFAULT.maxOutstandingBulkRequests());
        }
    }
}

