/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference.bulk;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceExecutionState;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRequestIterator;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRunnerConfig;

public class BulkInferenceRunner {
    private final Client client;
    private final Semaphore permits;
    private final ExecutorService executor;
    private final Queue<BulkInferenceRequest> pendingBulkRequests = new ConcurrentLinkedQueue<BulkInferenceRequest>(){
        private final Set<BulkInferenceRequest> requests = ConcurrentCollections.newConcurrentSet();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(BulkInferenceRequest bulkInferenceRequest) {
            Set<BulkInferenceRequest> set = this.requests;
            synchronized (set) {
                if (this.requests.add(bulkInferenceRequest)) {
                    return super.offer(bulkInferenceRequest);
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BulkInferenceRequest poll() {
            Set<BulkInferenceRequest> set = this.requests;
            synchronized (set) {
                BulkInferenceRequest request = (BulkInferenceRequest)super.poll();
                if (request != null) {
                    this.requests.remove(request);
                }
                return request;
            }
        }
    };

    public BulkInferenceRunner(Client client, int maxRunningTasks) {
        this.permits = new Semaphore(maxRunningTasks);
        this.client = client;
        this.executor = client.threadPool().executor("search");
    }

    public void executeBulk(BulkInferenceRequestIterator requests, ActionListener<List<InferenceAction.Response>> listener) {
        ArrayList responses = new ArrayList();
        this.executeBulk(requests, responses::add, (ActionListener<Void>)listener.delegateFailureIgnoreResponseAndWrap(l -> l.onResponse((Object)responses)));
    }

    public void executeBulk(BulkInferenceRequestIterator requests, Consumer<InferenceAction.Response> responseConsumer, ActionListener<Void> completionListener) {
        if (!requests.hasNext()) {
            completionListener.onResponse(null);
            return;
        }
        new BulkInferenceRequest(requests, responseConsumer, completionListener).executePendingRequests();
    }

    public ThreadPool threadPool() {
        return this.client.threadPool();
    }

    public static Factory factory(Client client) {
        return inferenceRunnerConfig -> new BulkInferenceRunner(client, inferenceRunnerConfig.maxOutstandingBulkRequests());
    }

    private class BulkInferenceRequest {
        private final BulkInferenceRequestIterator requests;
        private final Consumer<InferenceAction.Response> responseConsumer;
        private final ActionListener<Void> completionListener;
        private final BulkInferenceExecutionState executionState = new BulkInferenceExecutionState();
        private final AtomicBoolean responseSent = new AtomicBoolean(false);

        BulkInferenceRequest(BulkInferenceRequestIterator requests, Consumer<InferenceAction.Response> responseConsumer, ActionListener<Void> completionListener) {
            this.requests = requests;
            this.responseConsumer = responseConsumer;
            this.completionListener = completionListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BulkRequestItem pollPendingRequest() {
            BulkInferenceRequestIterator bulkInferenceRequestIterator = this.requests;
            synchronized (bulkInferenceRequestIterator) {
                if (this.requests.hasNext()) {
                    return new BulkRequestItem(this.executionState.generateSeqNo(), (InferenceAction.Request)this.requests.next());
                }
            }
            return null;
        }

        private void executePendingRequests() {
            this.executePendingRequests(0);
        }

        private void executePendingRequests(int recursionDepth) {
            try {
                while (!this.executionState.finished()) {
                    if (!BulkInferenceRunner.this.permits.tryAcquire()) {
                        if (this.requests.hasNext()) {
                            BulkInferenceRunner.this.pendingBulkRequests.add(this);
                        }
                        return;
                    }
                    BulkRequestItem bulkRequestItem = this.pollPendingRequest();
                    if (bulkRequestItem == null) {
                        BulkInferenceRunner.this.permits.release();
                        BulkInferenceRequest nexBulkRequest = BulkInferenceRunner.this.pendingBulkRequests.poll();
                        while (nexBulkRequest == this) {
                            nexBulkRequest = BulkInferenceRunner.this.pendingBulkRequests.poll();
                        }
                        if (nexBulkRequest != null) {
                            BulkInferenceRunner.this.executor.execute(nexBulkRequest::executePendingRequests);
                        }
                        return;
                    }
                    if (!this.requests.hasNext()) {
                        this.executionState.finish();
                    }
                    ThreadedActionListener inferenceResponseListener = new ThreadedActionListener((Executor)BulkInferenceRunner.this.executor, ActionListener.runAfter((ActionListener)ActionListener.wrap(r -> this.executionState.onInferenceResponse(bulkRequestItem.seqNo(), (InferenceAction.Response)r), e -> this.executionState.onInferenceException(bulkRequestItem.seqNo(), (Exception)e)), () -> {
                        block11: {
                            BulkInferenceRunner.this.permits.release();
                            try {
                                BulkInferenceExecutionState bulkInferenceExecutionState = this.executionState;
                                synchronized (bulkInferenceExecutionState) {
                                    this.persistPendingResponses();
                                }
                                if (this.executionState.finished() && this.responseSent.compareAndSet(false, true)) {
                                    this.onBulkCompletion();
                                }
                                if (this.responseSent.get()) {
                                    BulkInferenceRequest nexBulkRequest = BulkInferenceRunner.this.pendingBulkRequests.poll();
                                    if (nexBulkRequest != null) {
                                        BulkInferenceRunner.this.executor.execute(nexBulkRequest::executePendingRequests);
                                    }
                                    return;
                                }
                                if (!this.executionState.finished()) {
                                    if (recursionDepth > 100) {
                                        BulkInferenceRunner.this.executor.execute(this::executePendingRequests);
                                    } else {
                                        this.executePendingRequests(recursionDepth + 1);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (!this.responseSent.compareAndSet(false, true)) break block11;
                                this.completionListener.onFailure(e);
                            }
                        }
                    }));
                    if (bulkRequestItem.request() == null) {
                        inferenceResponseListener.onResponse(null);
                        return;
                    }
                    ClientHelper.executeAsyncWithOrigin((Client)BulkInferenceRunner.this.client, (String)"inference", (ActionType)InferenceAction.INSTANCE, (ActionRequest)bulkRequestItem.request(), (ActionListener)inferenceResponseListener);
                }
            }
            catch (Exception e2) {
                this.executionState.addFailure(e2);
            }
        }

        private void persistPendingResponses() {
            long persistedSeqNo = this.executionState.getPersistedCheckpoint();
            while (persistedSeqNo < this.executionState.getProcessedCheckpoint()) {
                ++persistedSeqNo;
                if (!this.executionState.hasFailure()) {
                    try {
                        InferenceAction.Response response = this.executionState.fetchBufferedResponse(persistedSeqNo);
                        this.responseConsumer.accept(response);
                    }
                    catch (Exception e) {
                        this.executionState.addFailure(e);
                    }
                }
                this.executionState.markSeqNoAsPersisted(persistedSeqNo);
            }
        }

        private void onBulkCompletion() {
            if (!this.executionState.hasFailure()) {
                try {
                    this.completionListener.onResponse(null);
                    return;
                }
                catch (Exception e) {
                    this.executionState.addFailure(e);
                }
            }
            this.completionListener.onFailure(this.executionState.getFailure());
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public BulkInferenceRunner create(BulkInferenceRunnerConfig var1);
    }

    private record BulkRequestItem(long seqNo, InferenceAction.Request request) {
    }
}

