/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.response;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.ChatCompletionResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;

public class OpenAiChatCompletionResponseEntity {
    public static ChatCompletionResults fromResponse(Request request, HttpResult response) throws IOException {
        return OpenAiChatCompletionResponseEntity.fromResponse(response.body());
    }

    public static ChatCompletionResults fromResponse(byte[] response) throws IOException {
        try (XContentParser p = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response);){
            ChatCompletionResults chatCompletionResults = ((CompletionResult)CompletionResult.PARSER.apply(p, null)).toChatCompletionResults();
            return chatCompletionResults;
        }
    }

    public record CompletionResult(List<Choice> choices) {
        public static final ConstructingObjectParser<CompletionResult, Void> PARSER = new ConstructingObjectParser(CompletionResult.class.getSimpleName(), true, args -> new CompletionResult((List)args[0]));

        public ChatCompletionResults toChatCompletionResults() {
            return new ChatCompletionResults(this.choices.stream().map(choice -> new ChatCompletionResults.Result(choice.message.content)).toList());
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> Choice.PARSER.apply(arg_0, arg_1), new ParseField("choices", new String[0]));
        }
    }

    public record Message(String content) {
        public static final ConstructingObjectParser<Message, Void> PARSER = new ConstructingObjectParser(Message.class.getSimpleName(), true, args -> new Message((String)args[0]));

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("content", new String[0]));
        }
    }

    public record Choice(Message message) {
        public static final ConstructingObjectParser<Choice, Void> PARSER = new ConstructingObjectParser(Choice.class.getSimpleName(), true, args -> new Choice((Message)args[0]));

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> Message.PARSER.apply(arg_0, arg_1), new ParseField("message", new String[0]));
        }
    }
}

