/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.contextualai;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkInferenceInput;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceExtension;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.RerankingInferenceService;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.contextualai.action.ContextualAiActionCreator;
import org.elasticsearch.xpack.inference.services.contextualai.rerank.ContextualAiRerankModel;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class ContextualAiService
extends SenderService
implements RerankingInferenceService {
    public static final String NAME = "contextualai";
    private static final String SERVICE_NAME = "Contextual AI";
    private static final TransportVersion CONTEXTUAL_AI_SERVICE = TransportVersion.fromName((String)"contextual_ai_service");
    private static final EnumSet<TaskType> SUPPORTED_TASK_TYPES = EnumSet.of(TaskType.RERANK);

    public ContextualAiService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents, InferenceServiceExtension.InferenceServiceFactoryContext context) {
        this(factory, serviceComponents, context.clusterService());
    }

    public ContextualAiService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents, ClusterService clusterService) {
        super(factory, serviceComponents, clusterService);
    }

    public String name() {
        return NAME;
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return SUPPORTED_TASK_TYPES;
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            ContextualAiRerankModel model = ContextualAiService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, serviceSettingsMap, ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    private static ContextualAiRerankModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secretSettings, ConfigurationParseContext context) {
        if (taskType != TaskType.RERANK) {
            throw ServiceUtils.createInvalidTaskTypeException(inferenceEntityId, NAME, taskType, context);
        }
        return new ContextualAiRerankModel(inferenceEntityId, serviceSettings, taskSettings, secretSettings, context);
    }

    public ContextualAiRerankModel parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(secrets, "secret_settings");
        return ContextualAiService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, secretSettingsMap, ConfigurationParseContext.PERSISTENT);
    }

    public ContextualAiRerankModel parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        return ContextualAiService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, null, ConfigurationParseContext.PERSISTENT);
    }

    @Override
    public void doInfer(Model model, InferenceInputs inputs, Map<String, Object> taskSettings, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof ContextualAiRerankModel)) {
            listener.onFailure((Exception)((Object)ServiceUtils.createInvalidModelException(model)));
            return;
        }
        ContextualAiRerankModel contextualAiModel = (ContextualAiRerankModel)model;
        ContextualAiActionCreator actionCreator = new ContextualAiActionCreator(this.getSender(), this.getServiceComponents());
        ExecutableAction action = contextualAiModel.accept(actionCreator, taskSettings);
        action.execute(inputs, timeout, listener);
    }

    @Override
    protected void doChunkedInfer(Model model, List<ChunkInferenceInput> inputs, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<List<ChunkedInference>> listener) {
        listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Chunked inference is not supported for rerank task", RestStatus.BAD_REQUEST, new Object[0])));
    }

    @Override
    protected void doUnifiedCompletionInfer(Model model, UnifiedChatInput inputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Unified completion is not supported for rerank task", RestStatus.BAD_REQUEST, new Object[0])));
    }

    @Override
    protected void validateInputType(InputType inputType, Model model, ValidationException validationException) {
    }

    public int rerankerWindowSize(String modelId) {
        return 5500;
    }

    public InferenceServiceConfiguration getConfiguration() {
        return Configuration.get();
    }

    public TransportVersion getMinimalSupportedVersion() {
        return CONTEXTUAL_AI_SERVICE;
    }

    public static class Configuration {
        private static final LazyInitializable<InferenceServiceConfiguration, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("model_id", new SettingsConfiguration.Builder(SUPPORTED_TASK_TYPES).setDescription("The model ID to use for Contextual AI requests.").setLabel("Model ID").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.putAll(DefaultSecretSettings.toSettingsConfiguration(SUPPORTED_TASK_TYPES));
            configurationMap.putAll(RateLimitSettings.toSettingsConfiguration(SUPPORTED_TASK_TYPES));
            return new InferenceServiceConfiguration.Builder().setService(ContextualAiService.NAME).setName(ContextualAiService.SERVICE_NAME).setTaskTypes(SUPPORTED_TASK_TYPES).setConfigurations(configurationMap).build();
        });

        public static InferenceServiceConfiguration get() {
            return (InferenceServiceConfiguration)configuration.getOrCompute();
        }
    }
}

