/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ai21.completion;

import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ai21.Ai21Model;
import org.elasticsearch.xpack.inference.services.ai21.action.Ai21ActionVisitor;
import org.elasticsearch.xpack.inference.services.ai21.completion.Ai21ChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class Ai21ChatCompletionModel
extends Ai21Model {
    public Ai21ChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, Ai21ChatCompletionServiceSettings.fromMap(serviceSettings, context), DefaultSecretSettings.fromMap(secrets));
    }

    public static Ai21ChatCompletionModel of(Ai21ChatCompletionModel model, UnifiedCompletionRequest request) {
        if (request.model() == null) {
            return model;
        }
        Ai21ChatCompletionServiceSettings originalModelServiceSettings = model.getServiceSettings();
        Ai21ChatCompletionServiceSettings overriddenServiceSettings = new Ai21ChatCompletionServiceSettings(request.model(), originalModelServiceSettings.rateLimitSettings());
        return new Ai21ChatCompletionModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), overriddenServiceSettings, model.getSecretSettings());
    }

    public Ai21ChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Ai21ChatCompletionServiceSettings serviceSettings, DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)new EmptyTaskSettings()), new ModelSecrets((SecretSettings)secrets));
        this.setPropertiesFromServiceSettings(serviceSettings);
    }

    private void setPropertiesFromServiceSettings(Ai21ChatCompletionServiceSettings serviceSettings) {
        this.rateLimitSettings = serviceSettings.rateLimitSettings();
        this.setEndpointUrl();
    }

    private void setEndpointUrl() {
        try {
            this.uri = new URIBuilder().setScheme("https").setHost("api.ai21.com").setPathSegments(new String[]{"studio", "v1", "chat", "completions"}).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Ai21ChatCompletionServiceSettings getServiceSettings() {
        return (Ai21ChatCompletionServiceSettings)super.getServiceSettings();
    }

    public ExecutableAction accept(Ai21ActionVisitor creator) {
        return creator.create(this);
    }
}

