/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rest;

import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.inference.action.GetInferenceModelAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetInferenceModelAction
extends BaseRestHandler {
    public static final String DEFAULT_ELSER_2_CAPABILITY = "default_elser_2";

    public String getName() {
        return "get_inference_model_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "_inference"), new RestHandler.Route(RestRequest.Method.GET, "_inference/_all"), new RestHandler.Route(RestRequest.Method.GET, "_inference/{task_type_or_id}"), new RestHandler.Route(RestRequest.Method.GET, "_inference/{task_type_or_id}/{inference_id}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String inferenceEntityId = null;
        TaskType taskType = null;
        if (!restRequest.hasParam("task_type_or_id") && !restRequest.hasParam("inference_id")) {
            inferenceEntityId = "_all";
            taskType = TaskType.ANY;
        } else if (restRequest.hasParam("inference_id")) {
            inferenceEntityId = restRequest.param("inference_id");
            taskType = TaskType.fromStringOrStatusException((String)restRequest.param("task_type_or_id"));
        } else {
            inferenceEntityId = restRequest.param("task_type_or_id");
            taskType = TaskType.ANY;
        }
        GetInferenceModelAction.Request request = new GetInferenceModelAction.Request(inferenceEntityId, taskType);
        return channel -> client.execute((ActionType)GetInferenceModelAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    public Set<String> supportedCapabilities() {
        return Set.of(DEFAULT_ELSER_2_CAPABILITY);
    }
}

