/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.sagemaker.schema.elastic;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.WeightedToken;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerModel;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.elastic.ElasticPayload;
import software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointResponse;

public class ElasticSparseEmbeddingPayload
implements ElasticPayload {
    private static final EnumSet<TaskType> SUPPORTED_TASKS = EnumSet.of(TaskType.SPARSE_EMBEDDING);
    private static final ConstructingObjectParser<SparseEmbeddingResults, Void> PARSER = new ConstructingObjectParser(SparseEmbeddingResults.class.getSimpleName(), false, args -> new SparseEmbeddingResults((List)args[0]));
    private static final ConstructingObjectParser<SparseEmbeddingResults.Embedding, Void> EMBEDDINGS_PARSER = new ConstructingObjectParser(SparseEmbeddingResults.class.getSimpleName(), false, args -> SparseEmbeddingResults.Embedding.create((List)((List)args[0]), (boolean)((Boolean)args[1])));

    @Override
    public EnumSet<TaskType> supportedTasks() {
        return SUPPORTED_TASKS;
    }

    public SparseEmbeddingResults responseBody(SageMakerModel model, InvokeEndpointResponse response) throws Exception {
        try (XContentParser p = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, response.body().asInputStream());){
            SparseEmbeddingResults sparseEmbeddingResults = (SparseEmbeddingResults)PARSER.apply(p, null);
            return sparseEmbeddingResults;
        }
    }

    static {
        EMBEDDINGS_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(HashMap::new, XContentParser::floatValue).entrySet().stream().map(entry -> new WeightedToken((String)entry.getKey(), ((Float)entry.getValue()).floatValue())).toList(), new ParseField("embedding", new String[0]));
        EMBEDDINGS_PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("is_truncated", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> EMBEDDINGS_PARSER.apply(arg_0, arg_1), new ParseField("sparse_embedding", new String[0]));
    }
}

