/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ibmwatsonx.request;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.request.IbmWatsonxRequest;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.request.IbmWatsonxRerankRequestEntity;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.rerank.IbmWatsonxRerankModel;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.rerank.IbmWatsonxRerankTaskSettings;

public class IbmWatsonxRerankRequest
implements IbmWatsonxRequest {
    private final String query;
    private final List<String> input;
    private final IbmWatsonxRerankTaskSettings taskSettings;
    private final IbmWatsonxRerankModel model;

    public IbmWatsonxRerankRequest(String query, List<String> input, IbmWatsonxRerankModel model) {
        Objects.requireNonNull(model);
        this.input = Objects.requireNonNull(input);
        this.query = Objects.requireNonNull(query);
        this.taskSettings = model.getTaskSettings();
        this.model = model;
    }

    @Override
    public HttpRequest createHttpRequest() {
        URI uri;
        try {
            uri = new URI(this.model.uri().toString());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("cannot parse URI patter");
        }
        HttpPost httpPost = new HttpPost(uri);
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new IbmWatsonxRerankRequestEntity(this.query, this.input, this.taskSettings, this.model.getServiceSettings().modelId(), this.model.getServiceSettings().projectId())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        this.decorateWithAuth(httpPost);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    public void decorateWithAuth(HttpPost httpPost) {
        IbmWatsonxRequest.decorateWithBearerToken(httpPost, this.model.getSecretSettings(), this.model.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.model.uri();
    }

    @Override
    public Request truncate() {
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public List<String> getInput() {
        return this.input;
    }

    public IbmWatsonxRerankModel getModel() {
        return this.model;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

