/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceUsageContext;

public record ElasticInferenceServiceDenseTextEmbeddingsRequestEntity(List<String> inputs, String modelId, @Nullable ElasticInferenceServiceUsageContext usageContext, @Nullable Integer dimensions) implements ToXContentObject
{
    private static final String INPUT_FIELD = "input";
    private static final String MODEL_FIELD = "model";
    private static final String USAGE_CONTEXT = "usage_context";
    private static final String DIMENSIONS = "dimensions";

    public ElasticInferenceServiceDenseTextEmbeddingsRequestEntity {
        Objects.requireNonNull(inputs);
        Objects.requireNonNull(modelId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(INPUT_FIELD);
        for (String input : this.inputs) {
            builder.value(input);
        }
        builder.endArray();
        builder.field(MODEL_FIELD, this.modelId);
        if (Objects.nonNull((Object)this.usageContext) && this.usageContext != ElasticInferenceServiceUsageContext.UNSPECIFIED) {
            builder.field(USAGE_CONTEXT, (Enum)this.usageContext);
        }
        if (Objects.nonNull(this.dimensions)) {
            builder.field(DIMENSIONS, this.dimensions);
        }
        builder.endObject();
        return builder;
    }
}

