/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations;

import java.util.function.BiFunction;
import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.search.sort.SortOrder;

abstract class PathArraySorter
extends IntroSorter {
    private final long[] points;
    protected final double[] sortValues;
    protected double sortValuePivot;

    static BiFunction<long[], double[], PathArraySorter> forOrder(SortOrder sortOrder) {
        return switch (sortOrder) {
            default -> throw new MatchException(null, null);
            case SortOrder.ASC -> Ascending::new;
            case SortOrder.DESC -> Descending::new;
        };
    }

    protected PathArraySorter(long[] points, double[] sortValues) {
        assert (points.length == sortValues.length);
        this.points = points;
        this.sortValues = sortValues;
        this.sortValuePivot = 0.0;
    }

    public void sort() {
        this.sort(0, this.points.length);
    }

    protected void swap(int i, int j) {
        long tmpPoint = this.points[i];
        this.points[i] = this.points[j];
        this.points[j] = tmpPoint;
        double tmpSortValue = this.sortValues[i];
        this.sortValues[i] = this.sortValues[j];
        this.sortValues[j] = tmpSortValue;
    }

    protected void setPivot(int i) {
        this.sortValuePivot = this.sortValues[i];
    }

    private static final class Descending
    extends PathArraySorter {
        private Descending(long[] points, double[] sortValues) {
            super(points, sortValues);
        }

        protected int comparePivot(int j) {
            return Double.compare(this.sortValues[j], this.sortValuePivot);
        }
    }

    private static final class Ascending
    extends PathArraySorter {
        private Ascending(long[] points, double[] sortValues) {
            super(points, sortValues);
        }

        protected int comparePivot(int j) {
            return Double.compare(this.sortValuePivot, this.sortValues[j]);
        }
    }
}

