/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.util.OptionalLong;
import org.elasticsearch.exponentialhistogram.AbstractExponentialHistogram;
import org.elasticsearch.exponentialhistogram.BucketArrayIterator;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ReleasableExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ZeroBucket;

class EmptyExponentialHistogram
extends AbstractExponentialHistogram
implements ReleasableExponentialHistogram {
    static final EmptyExponentialHistogram INSTANCE = new EmptyExponentialHistogram();
    private static final int SCALE = 38;

    EmptyExponentialHistogram() {
    }

    public void close() {
    }

    @Override
    public int scale() {
        return 38;
    }

    @Override
    public ZeroBucket zeroBucket() {
        return ZeroBucket.minimalEmpty();
    }

    @Override
    public ExponentialHistogram.Buckets positiveBuckets() {
        return EmptyBuckets.INSTANCE;
    }

    @Override
    public ExponentialHistogram.Buckets negativeBuckets() {
        return EmptyBuckets.INSTANCE;
    }

    @Override
    public double sum() {
        return 0.0;
    }

    @Override
    public double min() {
        return Double.NaN;
    }

    @Override
    public double max() {
        return Double.NaN;
    }

    public long ramBytesUsed() {
        return 0L;
    }

    private static class EmptyBuckets
    implements ExponentialHistogram.Buckets {
        private static final EmptyBuckets INSTANCE = new EmptyBuckets();
        private static final CopyableBucketIterator EMPTY_ITERATOR = new BucketArrayIterator(38, new long[0], new long[0], 0, 0);

        private EmptyBuckets() {
        }

        @Override
        public CopyableBucketIterator iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public OptionalLong maxBucketIndex() {
            return OptionalLong.empty();
        }

        @Override
        public long valueCount() {
            return 0L;
        }
    }
}

