/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetInferenceModelAction
extends ActionType<Response> {
    public static final GetInferenceModelAction INSTANCE = new GetInferenceModelAction();
    public static final String NAME = "cluster:monitor/xpack/inference/get";

    public GetInferenceModelAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<ModelConfigurations> endpoints;

        public Response(List<ModelConfigurations> endpoints) {
            this.endpoints = endpoints;
        }

        public Response(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
                this.endpoints = in.readCollectionAsList(ModelConfigurations::new);
            } else {
                this.endpoints = new ArrayList<ModelConfigurations>();
                this.endpoints.add(new ModelConfigurations(in));
            }
        }

        public List<ModelConfigurations> getEndpoints() {
            return this.endpoints;
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
                out.writeCollection(this.endpoints);
            } else {
                this.endpoints.get(0).writeTo(out);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("endpoints");
            for (ModelConfigurations endpoint : this.endpoints) {
                if (endpoint == null) continue;
                endpoint.toFilteredXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.endpoints, response.endpoints);
        }

        public int hashCode() {
            return Objects.hash(this.endpoints);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private static boolean PERSIST_DEFAULT_CONFIGS = true;
        private final String inferenceEntityId;
        private final TaskType taskType;
        private final boolean persistDefaultConfig;

        public Request(String inferenceEntityId, TaskType taskType) {
            this(inferenceEntityId, taskType, PERSIST_DEFAULT_CONFIGS);
        }

        public Request(String inferenceEntityId, TaskType taskType, boolean persistDefaultConfig) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.inferenceEntityId = Objects.requireNonNull(inferenceEntityId);
            this.taskType = Objects.requireNonNull(taskType);
            this.persistDefaultConfig = persistDefaultConfig;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.inferenceEntityId = in.readString();
            this.taskType = TaskType.fromStream((StreamInput)in);
            this.persistDefaultConfig = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0) ? in.readBoolean() : PERSIST_DEFAULT_CONFIGS;
        }

        public String getInferenceEntityId() {
            return this.inferenceEntityId;
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public boolean isPersistDefaultConfig() {
            return this.persistDefaultConfig;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.inferenceEntityId);
            this.taskType.writeTo(out);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
                out.writeBoolean(this.persistDefaultConfig);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.inferenceEntityId, request.inferenceEntityId) && this.taskType == request.taskType && this.persistDefaultConfig == request.persistDefaultConfig;
        }

        public int hashCode() {
            return Objects.hash(this.inferenceEntityId, this.taskType, this.persistDefaultConfig);
        }
    }
}

