/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class ExplainLifecycleRequest
extends LocalClusterStateRequest
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions;
    private boolean onlyErrors = false;
    private boolean onlyManaged = false;

    public ExplainLifecycleRequest(TimeValue masterTimeout) {
        super(masterTimeout);
        this.indicesOptions = IndicesOptions.strictExpandOpen();
    }

    public ExplainLifecycleRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        if (in.getTransportVersion().before((VersionId)TransportVersions.V_8_0_0)) {
            in.readStringArray();
        }
        this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        this.onlyErrors = in.readBoolean();
        this.onlyManaged = in.readBoolean();
    }

    public ExplainLifecycleRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public ExplainLifecycleRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public boolean includeDataStreams() {
        return true;
    }

    public boolean onlyErrors() {
        return this.onlyErrors;
    }

    public ExplainLifecycleRequest onlyErrors(boolean onlyErrors) {
        this.onlyErrors = onlyErrors;
        return this;
    }

    public boolean onlyManaged() {
        return this.onlyManaged;
    }

    public ExplainLifecycleRequest onlyManaged(boolean onlyManaged) {
        this.onlyManaged = onlyManaged;
        return this;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices()), this.indicesOptions(), this.onlyErrors, this.onlyManaged);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ExplainLifecycleRequest other = (ExplainLifecycleRequest)((Object)obj);
        return Objects.deepEquals(this.indices(), other.indices()) && Objects.equals(this.indicesOptions(), other.indicesOptions()) && Objects.equals(this.onlyErrors(), other.onlyErrors()) && Objects.equals(this.onlyManaged(), other.onlyManaged());
    }

    public String toString() {
        return "ExplainLifecycleRequest [indices()=" + Arrays.toString(this.indices()) + ", indicesOptions()=" + String.valueOf(this.indicesOptions()) + ", onlyErrors()=" + this.onlyErrors() + ", onlyManaged()=" + this.onlyManaged() + "]";
    }
}

