/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.persistent.CompletionPersistentTaskAction;
import org.elasticsearch.persistent.PersistentTaskResponse;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ccr.action.ShardFollowTask;

public final class ShardFollowTaskCleaner
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(ShardFollowTaskCleaner.class);
    private final ThreadPool threadPool;
    private final Client client;
    private final Set<ShardFollowTask> completing = Collections.synchronizedSet(new HashSet());

    public ShardFollowTaskCleaner(ClusterService clusterService, ThreadPool threadPool, Client client) {
        this.threadPool = threadPool;
        this.client = client;
        if (DiscoveryNode.isMasterNode((Settings)clusterService.getSettings())) {
            clusterService.addListener((ClusterStateListener)this);
        }
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (!event.localNodeMaster()) {
            return;
        }
        Metadata metadata = event.state().metadata();
        PersistentTasksCustomMetadata persistentTasksMetadata = (PersistentTasksCustomMetadata)metadata.getProject().custom("persistent_tasks");
        Metadata previousMetadata = event.previousState().metadata();
        if (metadata.getProject().indices() == event.previousState().getMetadata().getProject().indices() && persistentTasksMetadata == previousMetadata.getProject().custom("persistent_tasks") && event.previousState().nodes().isLocalNodeElectedMaster() && !event.blocksChanged()) {
            return;
        }
        if (persistentTasksMetadata == null) {
            return;
        }
        for (final PersistentTasksCustomMetadata.PersistentTask persistentTask : persistentTasksMetadata.tasks()) {
            if (!"xpack/ccr/shard_follow_task".equals(persistentTask.getTaskName())) continue;
            ShardFollowTask shardFollowTask = (ShardFollowTask)persistentTask.getParams();
            Index followerIndex = shardFollowTask.getFollowShardId().getIndex();
            if (metadata.getProject().index(followerIndex) != null || !this.completing.add(shardFollowTask)) continue;
            this.threadPool.generic().execute((Runnable)ActionRunnable.wrap((ActionListener)ActionListener.runBefore((ActionListener)new ActionListener<PersistentTaskResponse>(){

                public void onResponse(PersistentTaskResponse persistentTaskResponse) {
                    logger.debug("task [{}] cleaned up", (Object)persistentTask.getId());
                }

                public void onFailure(Exception e) {
                    logger.warn(() -> "failed to clean up task [" + persistentTask.getId() + "]", (Throwable)e);
                }
            }, () -> this.completing.remove(shardFollowTask)), listener -> {
                assert (this.threadPool.getThreadContext().isSystemContext());
                this.client.execute(CompletionPersistentTaskAction.INSTANCE, (ActionRequest)new CompletionPersistentTaskAction.Request(MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, persistentTask.getId(), persistentTask.getAllocationId(), (Exception)new IndexNotFoundException(followerIndex), null), listener);
            }));
        }
    }
}

