/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import org.apache.http.HttpHost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;

class NodeFailureListener
extends RestClient.FailureListener {
    private static final Logger logger = LogManager.getLogger(NodeFailureListener.class);
    @Nullable
    private final SetOnce<Sniffer> snifferHolder = new SetOnce();
    @Nullable
    private final SetOnce<HttpResource> resourceHolder = new SetOnce();

    NodeFailureListener() {
    }

    @Nullable
    public Sniffer getSniffer() {
        return (Sniffer)this.snifferHolder.get();
    }

    public void setSniffer(@Nullable Sniffer sniffer) {
        this.snifferHolder.set((Object)sniffer);
    }

    @Nullable
    public HttpResource getResource() {
        return (HttpResource)this.resourceHolder.get();
    }

    public void setResource(@Nullable HttpResource resource) {
        this.resourceHolder.set((Object)resource);
    }

    public void onFailure(Node node) {
        HttpHost host = node.getHost();
        logger.warn("connection failed to node at [{}://{}:{}]", (Object)host.getSchemeName(), (Object)host.getHostName(), (Object)host.getPort());
        HttpResource resource = (HttpResource)this.resourceHolder.get();
        Sniffer sniffer = (Sniffer)this.snifferHolder.get();
        if (resource != null) {
            resource.markDirty();
        }
        if (sniffer != null) {
            sniffer.sniffOnFailure();
        }
    }
}

