/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.RemoteConnectionManager;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.CrossClusterAccessSubjectInfo;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.ssl.SslProfile;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.action.SecurityActionMapper;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.CrossClusterAccessAuthenticationService;
import org.elasticsearch.xpack.security.authc.CrossClusterAccessHeaders;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.transport.CrossClusterAccessServerTransportFilter;
import org.elasticsearch.xpack.security.transport.CrossClusterApiKeySignatureManager;
import org.elasticsearch.xpack.security.transport.RemoteClusterTransportInterceptor;
import org.elasticsearch.xpack.security.transport.ServerTransportFilter;

public class CrossClusterAccessTransportInterceptor
implements RemoteClusterTransportInterceptor {
    private static final Logger logger = LogManager.getLogger(CrossClusterAccessTransportInterceptor.class);
    private static final Map<String, String> RCS_INTERNAL_ACTIONS_REPLACEMENTS = Map.of("internal:admin/ccr/restore/session/put", "indices:internal/admin/ccr/restore/session/put", "internal:admin/ccr/restore/session/clear", "indices:internal/admin/ccr/restore/session/clear", "internal:admin/ccr/restore/file_chunk/get", "indices:internal/admin/ccr/restore/file_chunk/get", "internal:data/read/esql/open_exchange", "cluster:internal:data/read/esql/open_exchange", "internal:data/read/esql/exchange", "cluster:internal:data/read/esql/exchange", "internal:admin/tasks/ban", "cluster:internal/admin/tasks/ban", "internal:admin/tasks/cancel_child", "cluster:internal/admin/tasks/cancel_child");
    private final Function<Transport.Connection, Optional<RemoteConnectionManager.RemoteClusterAliasWithCredentials>> remoteClusterCredentialsResolver;
    private final CrossClusterAccessAuthenticationService crossClusterAccessAuthcService;
    private final CrossClusterApiKeySignatureManager crossClusterApiKeySignatureManager;
    private final AuthenticationService authcService;
    private final AuthorizationService authzService;
    private final XPackLicenseState licenseState;
    private final SecurityContext securityContext;
    private final ThreadPool threadPool;
    private final Settings settings;

    public CrossClusterAccessTransportInterceptor(Settings settings, ThreadPool threadPool, AuthenticationService authcService, AuthorizationService authzService, SecurityContext securityContext, CrossClusterAccessAuthenticationService crossClusterAccessAuthcService, CrossClusterApiKeySignatureManager crossClusterApiKeySignatureManager, XPackLicenseState licenseState) {
        this(settings, threadPool, authcService, authzService, securityContext, crossClusterAccessAuthcService, crossClusterApiKeySignatureManager, licenseState, RemoteConnectionManager::resolveRemoteClusterAliasWithCredentials);
    }

    CrossClusterAccessTransportInterceptor(Settings settings, ThreadPool threadPool, AuthenticationService authcService, AuthorizationService authzService, SecurityContext securityContext, CrossClusterAccessAuthenticationService crossClusterAccessAuthcService, CrossClusterApiKeySignatureManager crossClusterApiKeySignatureManager, XPackLicenseState licenseState, Function<Transport.Connection, Optional<RemoteConnectionManager.RemoteClusterAliasWithCredentials>> remoteClusterCredentialsResolver) {
        this.remoteClusterCredentialsResolver = remoteClusterCredentialsResolver;
        this.crossClusterAccessAuthcService = crossClusterAccessAuthcService;
        this.crossClusterApiKeySignatureManager = crossClusterApiKeySignatureManager;
        this.authcService = authcService;
        this.authzService = authzService;
        this.licenseState = licenseState;
        this.securityContext = securityContext;
        this.threadPool = threadPool;
        this.settings = settings;
    }

    @Override
    public TransportInterceptor.AsyncSender interceptSender(final TransportInterceptor.AsyncSender sender) {
        return new TransportInterceptor.AsyncSender(){

            public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                Optional<RemoteClusterCredentials> remoteClusterCredentials = this.getRemoteClusterCredentials(connection);
                if (remoteClusterCredentials.isPresent()) {
                    this.sendWithCrossClusterAccessHeaders(remoteClusterCredentials.get(), connection, action, request, options, handler);
                } else {
                    try {
                        sender.sendRequest(connection, action, request, options, handler);
                    }
                    catch (Exception e) {
                        handler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e));
                    }
                }
            }

            private Optional<RemoteClusterCredentials> getRemoteClusterCredentials(Transport.Connection connection) {
                Optional<RemoteConnectionManager.RemoteClusterAliasWithCredentials> remoteClusterAliasWithCredentials = CrossClusterAccessTransportInterceptor.this.remoteClusterCredentialsResolver.apply(connection);
                if (remoteClusterAliasWithCredentials.isEmpty()) {
                    logger.trace("Connection is not remote");
                    return Optional.empty();
                }
                String remoteClusterAlias = remoteClusterAliasWithCredentials.get().clusterAlias();
                SecureString remoteClusterCredentials = remoteClusterAliasWithCredentials.get().credentials();
                if (remoteClusterCredentials == null) {
                    logger.trace("No cluster credentials are configured for remote cluster [{}]", (Object)remoteClusterAlias);
                    return Optional.empty();
                }
                return Optional.of(new RemoteClusterCredentials(remoteClusterAlias, ApiKeyService.withApiKeyPrefix(remoteClusterCredentials.toString())));
            }

            private <T extends TransportResponse> void sendWithCrossClusterAccessHeaders(RemoteClusterCredentials remoteClusterCredentials, Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                if (!Security.ADVANCED_REMOTE_CLUSTER_SECURITY_FEATURE.check(CrossClusterAccessTransportInterceptor.this.licenseState)) {
                    throw LicenseUtils.newComplianceException((String)Security.ADVANCED_REMOTE_CLUSTER_SECURITY_FEATURE.getName());
                }
                String remoteClusterAlias = remoteClusterCredentials.clusterAlias();
                if (connection.getTransportVersion().before((VersionId)RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY)) {
                    throw 1.illegalArgumentExceptionWithDebugLog("Settings for remote cluster [" + remoteClusterAlias + "] indicate cross cluster access headers should be sent but target cluster version [" + connection.getTransportVersion().toReleaseVersion() + "] does not support receiving them");
                }
                logger.trace(() -> Strings.format((String)"Sending [%s] request for [%s] action to [%s] with cross cluster access headers", (Object[])new Object[]{request.getClass(), action, remoteClusterAlias}));
                Authentication authentication = CrossClusterAccessTransportInterceptor.this.securityContext.getAuthentication();
                assert (authentication != null) : "authentication must be present in security context";
                User user = authentication.getEffectiveSubject().getUser();
                if (user instanceof InternalUser && !SystemUser.is((User)user)) {
                    String message = "Internal user [" + user.principal() + "] should not be used for cross cluster requests";
                    assert (false) : message;
                    throw 1.illegalArgumentExceptionWithDebugLog(message);
                }
                if (SystemUser.is((User)user) || action.equals("cluster:monitor/state")) {
                    if (SystemUser.is((User)user)) {
                        logger.trace("Request [{}] for action [{}] towards [{}] initiated by the system user. Sending request with internal cross cluster access user headers", (Object)request.getClass(), (Object)action, (Object)remoteClusterAlias);
                    } else {
                        logger.trace(() -> Strings.format((String)"Switching to the system user for cluster state action towards [{}]. Original user is [%s]", (Object[])new Object[]{remoteClusterAlias, user}));
                    }
                    CrossClusterAccessHeaders crossClusterAccessHeaders = new CrossClusterAccessHeaders(remoteClusterCredentials.credentials(), SystemUser.crossClusterAccessSubjectInfo((TransportVersion)authentication.getEffectiveSubject().getTransportVersion(), (String)authentication.getEffectiveSubject().getRealm().getNodeName()));
                    String effectiveAction = RCS_INTERNAL_ACTIONS_REPLACEMENTS.getOrDefault(action, action);
                    if (!effectiveAction.equals(action)) {
                        logger.trace("switching internal action from [{}] to [{}]", (Object)action, (Object)effectiveAction);
                    }
                    this.sendWithCrossClusterAccessHeaders(crossClusterAccessHeaders, connection, effectiveAction, request, options, handler);
                } else {
                    assert (!action.startsWith("internal:")) : "internal action must be sent with system user";
                    CrossClusterAccessTransportInterceptor.this.authzService.getRoleDescriptorsIntersectionForRemoteCluster(remoteClusterAlias, connection.getTransportVersion(), authentication.getEffectiveSubject(), (ActionListener<RoleDescriptorsIntersection>)ActionListener.wrap(roleDescriptorsIntersection -> {
                        logger.trace(() -> Strings.format((String)"Subject [%s] has role descriptors intersection [%s] for action [%s] towards remote cluster [%s]", (Object[])new Object[]{authentication.getEffectiveSubject(), roleDescriptorsIntersection, action, remoteClusterAlias}));
                        if (roleDescriptorsIntersection.isEmpty()) {
                            throw CrossClusterAccessTransportInterceptor.this.authzService.remoteActionDenied(authentication, SecurityActionMapper.action(action, request), remoteClusterAlias);
                        }
                        CrossClusterAccessHeaders crossClusterAccessHeaders = new CrossClusterAccessHeaders(remoteClusterCredentials.credentials(), new CrossClusterAccessSubjectInfo(authentication, roleDescriptorsIntersection));
                        this.sendWithCrossClusterAccessHeaders(crossClusterAccessHeaders, connection, action, request, options, handler);
                    }, e -> handler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e))));
                }
            }

            private <T extends TransportResponse> void sendWithCrossClusterAccessHeaders(CrossClusterAccessHeaders crossClusterAccessHeaders, Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                ThreadContext threadContext = CrossClusterAccessTransportInterceptor.this.securityContext.getThreadContext();
                TransportService.ContextRestoreResponseHandler contextRestoreHandler = new TransportService.ContextRestoreResponseHandler(threadContext.newRestorableContext(true), handler);
                try (ThreadContext.StoredContext ignored = threadContext.stashContextPreservingRequestHeaders(ThreadContext.HeadersFor.REMOTE_CLUSTER, new String[]{"_xpack_audit_request_id"});){
                    crossClusterAccessHeaders.writeToContext(threadContext);
                    sender.sendRequest(connection, action, request, options, (TransportResponseHandler)contextRestoreHandler);
                }
                catch (Exception e) {
                    contextRestoreHandler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e));
                }
            }

            private static IllegalArgumentException illegalArgumentExceptionWithDebugLog(String message) {
                logger.debug(message);
                return new IllegalArgumentException(message);
            }
        };
    }

    @Override
    public boolean isRemoteClusterConnection(Transport.Connection connection) {
        return this.remoteClusterCredentialsResolver.apply(connection).map(RemoteConnectionManager.RemoteClusterAliasWithCredentials::clusterAlias).isPresent();
    }

    @Override
    public Map<String, ServerTransportFilter> getProfileTransportFilters(Map<String, SslProfile> profileConfigurations, DestructiveOperations destructiveOperations) {
        Map profileFilters = Maps.newMapWithExpectedSize((int)(profileConfigurations.size() + 1));
        boolean transportSSLEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(this.settings);
        boolean remoteClusterPortEnabled = (Boolean)RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED.get(this.settings);
        boolean remoteClusterServerSSLEnabled = (Boolean)XPackSettings.REMOTE_CLUSTER_SERVER_SSL_ENABLED.get(this.settings);
        for (Map.Entry<String, SslProfile> entry : profileConfigurations.entrySet()) {
            boolean useRemoteClusterProfile;
            String profileName = entry.getKey();
            SslProfile sslProfile = entry.getValue();
            SslConfiguration profileConfiguration = sslProfile.configuration();
            assert (profileConfiguration != null) : "Ssl Profile [" + String.valueOf(sslProfile) + "] for [" + profileName + "] has a null configuration";
            boolean bl = useRemoteClusterProfile = remoteClusterPortEnabled && profileName.equals("_remote_cluster");
            if (useRemoteClusterProfile) {
                profileFilters.put(profileName, new CrossClusterAccessServerTransportFilter(this.crossClusterAccessAuthcService, this.authzService, this.threadPool.getThreadContext(), remoteClusterServerSSLEnabled && SSLService.isSSLClientAuthEnabled((SslConfiguration)profileConfiguration), destructiveOperations, this.securityContext, this.licenseState));
                continue;
            }
            profileFilters.put(profileName, new ServerTransportFilter(this.authcService, this.authzService, this.threadPool.getThreadContext(), transportSSLEnabled && SSLService.isSSLClientAuthEnabled((SslConfiguration)profileConfiguration), destructiveOperations, this.securityContext));
        }
        return Collections.unmodifiableMap(profileFilters);
    }

    @Override
    public boolean hasRemoteClusterAccessHeadersInContext(SecurityContext securityContext) {
        return securityContext.getThreadContext().getHeader("_cross_cluster_access_credentials") != null || securityContext.getThreadContext().getHeader("_cross_cluster_access_subject_info") != null;
    }

    CrossClusterApiKeySignatureManager getCrossClusterApiKeySignatureManager() {
        return this.crossClusterApiKeySignatureManager;
    }

    record RemoteClusterCredentials(String clusterAlias, String credentials) {
        @Override
        public String toString() {
            return "RemoteClusterCredentials{clusterAlias='" + this.clusterAlias + "', credentials='::es_redacted::'}";
        }
    }
}

