/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal.common;

import com.nvidia.cuvs.internal.common.LinkerHelper;
import com.nvidia.cuvs.internal.common.Util;
import com.nvidia.cuvs.internal.panama.headers_h;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;

public class PinnedMemoryBuffer
implements AutoCloseable {
    private static final int CHUNK_BYTES = 0x800000;
    private final long hostBufferBytes;
    private MemorySegment hostBuffer = MemorySegment.NULL;

    public PinnedMemoryBuffer(long rows, long columns, ValueLayout valueLayout) {
        long rowBytes = columns * valueLayout.byteSize();
        long matrixBytes = rows * rowBytes;
        if (matrixBytes < 0x800000L) {
            this.hostBufferBytes = matrixBytes;
        } else if (rowBytes > 0x800000L) {
            this.hostBufferBytes = rowBytes;
        } else {
            long rowCount = 0x800000L / rowBytes;
            this.hostBufferBytes = rowBytes * rowCount;
        }
    }

    private static MemorySegment createPinnedBuffer(long bufferBytes) {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment pointer = localArena.allocate(LinkerHelper.C_POINTER);
            Util.checkCudaError(headers_h.cudaMallocHost(pointer, bufferBytes), "cudaMallocHost");
            MemorySegment memorySegment = pointer.get(LinkerHelper.C_POINTER, 0L);
            return memorySegment;
        }
    }

    private static void destroyPinnedBuffer(MemorySegment bufferSegment) {
        Util.checkCudaError(headers_h.cudaFreeHost(bufferSegment), "cudaFreeHost");
    }

    public MemorySegment address() {
        if (this.hostBuffer == MemorySegment.NULL) {
            this.hostBuffer = PinnedMemoryBuffer.createPinnedBuffer(this.hostBufferBytes);
        }
        return this.hostBuffer;
    }

    public long size() {
        return this.hostBufferBytes;
    }

    @Override
    public void close() {
        if (this.hostBuffer != MemorySegment.NULL) {
            PinnedMemoryBuffer.destroyPinnedBuffer(this.hostBuffer);
            this.hostBuffer = MemorySegment.NULL;
        }
    }
}

