/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.common.http;

import java.util.Locale;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;

public enum HttpContentType {
    JSON{

        @Override
        public XContentType contentType() {
            return XContentType.JSON;
        }
    }
    ,
    YAML{

        @Override
        public XContentType contentType() {
            return XContentType.YAML;
        }
    }
    ,
    TEXT{

        @Override
        public XContentType contentType() {
            return null;
        }
    };


    public abstract XContentType contentType();

    public String toString() {
        return this.id();
    }

    public String id() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static HttpContentType resolve(String id) {
        return switch (id.toLowerCase(Locale.ROOT)) {
            case "json" -> JSON;
            case "yaml" -> YAML;
            case "text" -> TEXT;
            default -> throw Exceptions.illegalArgument((String)"unknown http content type [{}]", (Object[])new Object[]{id});
        };
    }
}

