/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.categorization;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.charfilter.BaseCharFilter;

public class FirstNonBlankLineCharFilter
extends BaseCharFilter {
    public static final String NAME = "first_non_blank_line";
    private Reader transformedInput;

    FirstNonBlankLineCharFilter(Reader in) {
        super(in);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.transformedInput == null) {
            this.fill();
        }
        return this.transformedInput.read(cbuf, off, len);
    }

    public int read() throws IOException {
        if (this.transformedInput == null) {
            this.fill();
        }
        return this.transformedInput.read();
    }

    private void fill() throws IOException {
        StringBuilder buffered = new StringBuilder();
        char[] temp = new char[1024];
        int cnt = this.input.read(temp);
        while (cnt > 0) {
            buffered.append(temp, 0, cnt);
            cnt = this.input.read(temp);
        }
        this.transformedInput = new StringReader(this.process(buffered).toString());
    }

    private CharSequence process(CharSequence input) {
        boolean seenNonWhitespaceChar = false;
        int prevNewlineIndex = -1;
        int endIndex = -1;
        for (int index = 0; index < input.length(); ++index) {
            if (input.charAt(index) == '\n') {
                if (seenNonWhitespaceChar) {
                    endIndex = input.charAt(index - 1) == '\r' ? index - 1 : index;
                    break;
                }
                prevNewlineIndex = index;
                continue;
            }
            seenNonWhitespaceChar = seenNonWhitespaceChar || !Character.isWhitespace(input.charAt(index));
        }
        if (!seenNonWhitespaceChar) {
            return "";
        }
        if (endIndex == -1) {
            if (prevNewlineIndex == -1) {
                return input;
            }
            endIndex = input.length();
        }
        this.addOffCorrectMap(0, prevNewlineIndex + 1);
        if (endIndex < input.length()) {
            this.addOffCorrectMap(endIndex - prevNewlineIndex - 1, input.length() - endIndex + prevNewlineIndex + 1);
        }
        return input.subSequence(prevNewlineIndex + 1, endIndex);
    }
}

