/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp.tokenizers;

import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import org.elasticsearch.xpack.ml.inference.nlp.tokenizers.TokenizerUtils;

public class BpeTokenReader {
    private final CharSequence inputChars;
    int count;
    private final Queue<Integer> putBackChar = new LinkedList<Integer>();
    boolean inSpacePrefix = false;
    boolean inAnyLetter = false;
    boolean inAnyNumber = false;
    boolean inSymbol = false;
    boolean inWhiteSpace = false;
    int offsetStart = 0;
    int offsetEnd = 0;

    public BpeTokenReader(CharSequence input) {
        this.inputChars = input;
    }

    public Optional<TokenizerUtils.CharSequenceRef> next() {
        int curIntChar;
        this.offsetStart = this.offsetEnd;
        while ((curIntChar = this.getNextChar()) >= 0) {
            int nextInt;
            char curChar = (char)curIntChar;
            if (BpeTokenReader.isApostrophe(curChar)) {
                if (this.inSymbol) {
                    ++this.offsetEnd;
                    continue;
                }
                if (this.inAnythingOtherThanSpace()) {
                    this.putBackChar.add(curIntChar);
                    return Optional.of(this.tokenComplete());
                }
                this.inSymbol = true;
                if (this.inSpacePrefix) {
                    ++this.offsetEnd;
                    continue;
                }
                ++this.offsetEnd;
                int nextIntChar = this.getNextChar();
                if (nextIntChar < 0) {
                    return Optional.of(this.tokenComplete());
                }
                if (nextIntChar == 115 || nextIntChar == 116 || nextIntChar == 109 || nextIntChar == 100) {
                    ++this.offsetEnd;
                } else if (nextIntChar == 114 || nextIntChar == 118 || nextIntChar == 108) {
                    int nextNextIntChar = this.getNextChar();
                    if (nextNextIntChar == 101 || nextNextIntChar == 108) {
                        ++this.offsetEnd;
                        ++this.offsetEnd;
                    } else {
                        this.putBackChar.add(nextIntChar);
                        if (nextNextIntChar >= 0) {
                            this.putBackChar.add(nextNextIntChar);
                        }
                    }
                } else {
                    this.putBackChar.add(nextIntChar);
                }
                return Optional.of(this.tokenComplete());
            }
            if (this.inAnyLetter) {
                if (Character.isLetter(curChar)) {
                    ++this.offsetEnd;
                    continue;
                }
                this.putBackChar.add(curIntChar);
                return Optional.of(this.tokenComplete());
            }
            if (Character.isLetter(curChar)) {
                if (this.inAnythingOtherThanSpace()) {
                    this.putBackChar.add(curIntChar);
                    return Optional.of(this.tokenComplete());
                }
                this.inAnyLetter = true;
                ++this.offsetEnd;
                continue;
            }
            if (this.inAnyNumber) {
                if (Character.isDigit(curChar)) {
                    ++this.offsetEnd;
                    continue;
                }
                this.putBackChar.add(curIntChar);
                return Optional.of(this.tokenComplete());
            }
            if (Character.isDigit(curChar)) {
                if (this.inAnythingOtherThanSpace()) {
                    this.putBackChar.add(curIntChar);
                    return Optional.of(this.tokenComplete());
                }
                this.inAnyNumber = true;
                ++this.offsetEnd;
                continue;
            }
            if (this.inSymbol) {
                if (BpeTokenReader.isSymbol(curChar)) {
                    ++this.offsetEnd;
                    continue;
                }
                this.putBackChar.add(curIntChar);
                return Optional.of(this.tokenComplete());
            }
            if (BpeTokenReader.isSymbol(curChar)) {
                if (this.inAnythingOtherThanSpace()) {
                    this.putBackChar.add(curIntChar);
                    return Optional.of(this.tokenComplete());
                }
                this.inSymbol = true;
                ++this.offsetEnd;
                continue;
            }
            if (this.inWhiteSpace) {
                if (Character.isWhitespace(curChar) && !BpeTokenReader.isSpace(curChar)) {
                    ++this.offsetEnd;
                    continue;
                }
                if (BpeTokenReader.isSpace(curChar)) {
                    nextInt = this.getNextChar();
                    if (nextInt < 0) {
                        ++this.offsetEnd;
                        return Optional.of(this.tokenComplete());
                    }
                    if (Character.isWhitespace(nextInt)) {
                        ++this.offsetEnd;
                        this.putBackChar.add(nextInt);
                        continue;
                    }
                    this.putBackChar.add(curIntChar);
                    this.putBackChar.add(nextInt);
                    return Optional.of(this.tokenComplete());
                }
                this.putBackChar.add(curIntChar);
                return Optional.of(this.tokenComplete());
            }
            if (!Character.isWhitespace(curChar)) continue;
            if (this.inAnythingOtherThanSpace()) {
                this.putBackChar.add(curIntChar);
                return Optional.of(this.tokenComplete());
            }
            if (BpeTokenReader.isSpace(curChar) && !this.inSpacePrefix) {
                ++this.offsetEnd;
                this.inSpacePrefix = true;
                continue;
            }
            if (BpeTokenReader.isSpace(curChar)) {
                nextInt = this.getNextChar();
                if (nextInt < 0) {
                    ++this.offsetEnd;
                    return Optional.of(this.tokenComplete());
                }
                if (Character.isWhitespace(nextInt)) {
                    this.inWhiteSpace = true;
                    ++this.offsetEnd;
                    this.putBackChar.add(nextInt);
                    continue;
                }
                this.putBackChar.add(curIntChar);
                this.putBackChar.add(nextInt);
                return Optional.of(this.tokenComplete());
            }
            this.inWhiteSpace = true;
            ++this.offsetEnd;
        }
        if (this.offsetEnd > this.offsetStart) {
            return Optional.of(this.tokenComplete());
        }
        return Optional.empty();
    }

    private TokenizerUtils.CharSequenceRef tokenComplete() {
        this.inWhiteSpace = false;
        this.inSpacePrefix = false;
        this.inSymbol = false;
        this.inAnyLetter = false;
        this.inAnyNumber = false;
        return new TokenizerUtils.CharSequenceRef(this.inputChars, this.offsetStart, this.offsetEnd - this.offsetStart);
    }

    private boolean inAnythingOtherThanSpace() {
        return this.inAnyNumber || this.inAnyLetter || this.inSymbol || this.inWhiteSpace;
    }

    private int getNextChar() {
        if (this.putBackChar.isEmpty()) {
            if (this.count >= this.inputChars.length()) {
                return -1;
            }
            return this.inputChars.charAt(this.count++);
        }
        return this.putBackChar.poll();
    }

    private static boolean isSymbol(char c) {
        return !Character.isDigit(c) && !Character.isLetter(c) && !Character.isWhitespace(c);
    }

    private static boolean isSpace(char c) {
        return c == ' ';
    }

    private static boolean isApostrophe(char c) {
        return c == '\'';
    }
}

