/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.completion;

import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleModelGardenProvider;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.request.GoogleVertexAiUtils;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class GoogleVertexAiChatCompletionServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
GoogleVertexAiRateLimitServiceSettings {
    public static final String NAME = "google_vertex_ai_chatcompletion_service_settings";
    private static final TransportVersion ML_INFERENCE_VERTEXAI_CHATCOMPLETION_ADDED = TransportVersion.fromName((String)"ml_inference_vertexai_chatcompletion_added");
    private final String location;
    private final String modelId;
    private final String projectId;
    private final URI uri;
    private final URI streamingUri;
    private final GoogleModelGardenProvider provider;
    private final RateLimitSettings rateLimitSettings;
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(1000L);

    public GoogleVertexAiChatCompletionServiceSettings(StreamInput in) throws IOException {
        String modelIdFromStreamInput;
        String locationFromStreamInput;
        String projectIdFromStreamInput;
        TransportVersion version = in.getTransportVersion();
        URI uriFromStreamInput = null;
        URI streamingUriFromStreamInput = null;
        GoogleModelGardenProvider providerFromStreamInput = null;
        if (GoogleVertexAiUtils.supportsModelGarden(version)) {
            projectIdFromStreamInput = in.readOptionalString();
            locationFromStreamInput = in.readOptionalString();
            modelIdFromStreamInput = in.readOptionalString();
            uriFromStreamInput = ServiceUtils.createOptionalUri(in.readOptionalString());
            streamingUriFromStreamInput = ServiceUtils.createOptionalUri(in.readOptionalString());
            providerFromStreamInput = (GoogleModelGardenProvider)in.readOptionalEnum(GoogleModelGardenProvider.class);
        } else {
            projectIdFromStreamInput = in.readString();
            locationFromStreamInput = in.readString();
            modelIdFromStreamInput = in.readString();
        }
        RateLimitSettings rateLimitSettingsFromStreamInput = new RateLimitSettings(in);
        this.projectId = Strings.isNullOrEmpty((String)projectIdFromStreamInput) ? null : projectIdFromStreamInput;
        this.location = Strings.isNullOrEmpty((String)locationFromStreamInput) ? null : locationFromStreamInput;
        this.modelId = Strings.isNullOrEmpty((String)modelIdFromStreamInput) ? null : modelIdFromStreamInput;
        this.uri = uriFromStreamInput;
        this.streamingUri = streamingUriFromStreamInput;
        this.provider = Objects.requireNonNullElse(providerFromStreamInput, GoogleModelGardenProvider.GOOGLE);
        this.rateLimitSettings = rateLimitSettingsFromStreamInput;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!Strings.isNullOrEmpty((String)this.projectId)) {
            builder.field("project_id", this.projectId);
        }
        if (!Strings.isNullOrEmpty((String)this.location)) {
            builder.field("location", this.location);
        }
        if (!Strings.isNullOrEmpty((String)this.modelId)) {
            builder.field("model_id", this.modelId);
        }
        if (this.uri != null) {
            builder.field("url", this.uri.toString());
        }
        if (this.streamingUri != null) {
            builder.field("streaming_url", this.streamingUri.toString());
        }
        if (this.provider != null) {
            builder.field("provider", this.provider.name());
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public static GoogleVertexAiChatCompletionServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String projectId = ServiceUtils.extractOptionalString(map, "project_id", "service_settings", validationException);
        String location = ServiceUtils.extractOptionalString(map, "location", "service_settings", validationException);
        String modelId = ServiceUtils.extractOptionalString(map, "model_id", "service_settings", validationException);
        URI uri = ServiceUtils.extractOptionalUri(map, "url", validationException);
        URI streamingUri = ServiceUtils.extractOptionalUri(map, "streaming_url", validationException);
        GoogleModelGardenProvider provider = ServiceUtils.extractOptionalEnum(map, "provider", "service_settings", GoogleModelGardenProvider::fromString, EnumSet.allOf(GoogleModelGardenProvider.class), validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "googlevertexai", context);
        GoogleVertexAiChatCompletionServiceSettings.validateServiceSettings(provider, uri, streamingUri, projectId, location, modelId, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GoogleVertexAiChatCompletionServiceSettings(projectId, location, modelId, uri, streamingUri, provider, rateLimitSettings);
    }

    private static void validateServiceSettings(GoogleModelGardenProvider provider, URI uri, URI streamingUri, String projectId, String location, String modelId, ValidationException validationException) {
        boolean hasAllVertexFields;
        boolean isNonGoogleProvider = provider != null && provider != GoogleModelGardenProvider.GOOGLE;
        boolean hasAnyUrl = uri != null || streamingUri != null;
        boolean bl = hasAllVertexFields = projectId != null && location != null && modelId != null;
        if (isNonGoogleProvider) {
            if (!hasAnyUrl) {
                validationException.addValidationError(String.format(Locale.ROOT, "Google Model Garden provider=%s selected. Either 'uri' or 'streaming_uri' must be provided", new Object[]{provider}));
            }
        } else if (hasAnyUrl) {
            validationException.addValidationError(String.format(Locale.ROOT, "'provider' is either GOOGLE or null. For Google Vertex AI models 'uri' and 'streaming_uri' must not be provided. Remove 'url' and 'streaming_url' fields. Provided values: uri=%s, streaming_uri=%s", uri, streamingUri));
        } else if (!hasAllVertexFields) {
            validationException.addValidationError(String.format(Locale.ROOT, "For Google Vertex AI models, you must provide 'location', 'project_id', and 'model_id'. Provided values: location=%s, project_id=%s, model_id=%s", location, projectId, modelId));
        }
    }

    public GoogleVertexAiChatCompletionServiceSettings(@Nullable String projectId, @Nullable String location, @Nullable String modelId, @Nullable URI uri, @Nullable URI streamingUri, @Nullable GoogleModelGardenProvider provider, @Nullable RateLimitSettings rateLimitSettings) {
        this.projectId = projectId;
        this.location = location;
        this.modelId = modelId;
        this.uri = uri;
        this.streamingUri = streamingUri;
        this.provider = Objects.requireNonNullElse(provider, GoogleModelGardenProvider.GOOGLE);
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public String location() {
        return this.location;
    }

    public String modelId() {
        return this.modelId;
    }

    @Override
    public String projectId() {
        return this.projectId;
    }

    public URI uri() {
        return this.uri;
    }

    public URI streamingUri() {
        return this.streamingUri;
    }

    public GoogleModelGardenProvider provider() {
        return this.provider;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return ML_INFERENCE_VERTEXAI_CHATCOMPLETION_ADDED;
    }

    public boolean supportsVersion(TransportVersion version) {
        return version.supports(ML_INFERENCE_VERTEXAI_CHATCOMPLETION_ADDED);
    }

    public void writeTo(StreamOutput out) throws IOException {
        TransportVersion version = out.getTransportVersion();
        if (GoogleVertexAiUtils.supportsModelGarden(version)) {
            out.writeOptionalString(this.projectId);
            out.writeOptionalString(this.location);
            out.writeOptionalString(this.modelId);
            out.writeOptionalString(this.uri != null ? this.uri.toString() : null);
            out.writeOptionalString(this.streamingUri != null ? this.streamingUri.toString() : null);
            out.writeOptionalEnum((Enum)this.provider);
        } else {
            out.writeString(Objects.requireNonNullElse(this.projectId, ""));
            out.writeString(Objects.requireNonNullElse(this.location, ""));
            out.writeString(Objects.requireNonNullElse(this.modelId, ""));
        }
        this.rateLimitSettings.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoogleVertexAiChatCompletionServiceSettings that = (GoogleVertexAiChatCompletionServiceSettings)o;
        return Objects.equals(this.location, that.location) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.projectId, that.projectId) && Objects.equals(this.uri, that.uri) && Objects.equals(this.streamingUri, that.streamingUri) && Objects.equals((Object)this.provider, (Object)that.provider) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.location, this.modelId, this.projectId, this.uri, this.streamingUri, this.provider, this.rateLimitSettings});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

