/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ModelPackageConfig;

final class TrainedModelValidator {
    static void validatePackage(TrainedModelConfig.Builder trainedModelConfig, ModelPackageConfig resolvedModelPackageConfig, ClusterState state) {
        TrainedModelValidator.validateMinimumVersion(resolvedModelPackageConfig, state);
        trainedModelConfig.validateNoPackageOverrides();
    }

    static void validateMinimumVersion(ModelPackageConfig resolvedModelPackageConfig, ClusterState state) {
        MlConfigVersion minimumVersion;
        if (org.elasticsearch.common.Strings.isNullOrEmpty((String)resolvedModelPackageConfig.getMinimumVersion())) {
            throw new ActionRequestValidationException().addValidationError(Strings.format((String)"Invalid model package configuration for [%s], missing minimum_version property", (Object[])new Object[]{resolvedModelPackageConfig.getPackagedModelId()}));
        }
        try {
            minimumVersion = MlConfigVersion.fromString((String)resolvedModelPackageConfig.getMinimumVersion());
        }
        catch (IllegalArgumentException e) {
            throw new ActionRequestValidationException().addValidationError(Strings.format((String)"Invalid model package configuration for [%s], failed to parse the minimum_version property", (Object[])new Object[]{resolvedModelPackageConfig.getPackagedModelId()}));
        }
        if (MlConfigVersion.getMinMlConfigVersion((DiscoveryNodes)state.nodes()).before((VersionId)minimumVersion)) {
            throw new ActionRequestValidationException().addValidationError(Strings.format((String)"The model [%s] requires that all nodes have ML config version [%s] or higher", (Object[])new Object[]{resolvedModelPackageConfig.getPackagedModelId(), resolvedModelPackageConfig.getMinimumVersion()}));
        }
    }

    private TrainedModelValidator() {
    }
}

