/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ParserConstructor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.esql.action.ColumnInfo;
import org.elasticsearch.xpack.esql.core.type.DataType;

public class ColumnInfoImpl
implements ColumnInfo {
    public static final InstantiatingObjectParser<ColumnInfoImpl, Void> PARSER;
    private static final TransportVersion ESQL_REPORT_ORIGINAL_TYPES;
    private final String name;
    private final DataType type;
    @Nullable
    private final List<String> originalTypes;
    @Nullable
    private final DataType suggestedCast;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ColumnInfoImpl) {
            ColumnInfoImpl that = (ColumnInfoImpl)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.originalTypes, that.originalTypes);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.originalTypes);
    }

    public static ColumnInfo fromXContent(XContentParser parser) {
        return (ColumnInfo)PARSER.apply(parser, null);
    }

    @ParserConstructor
    public ColumnInfoImpl(String name, String type, @Nullable List<String> originalTypes) {
        this(name, DataType.fromEs((String)type), originalTypes);
    }

    public ColumnInfoImpl(String name, DataType type, @Nullable List<String> originalTypes) {
        this.name = name;
        this.type = type;
        this.originalTypes = originalTypes;
        this.suggestedCast = ColumnInfoImpl.calculateSuggestedCast(this.originalTypes);
    }

    private static DataType calculateSuggestedCast(List<String> originalTypes) {
        if (originalTypes == null) {
            return null;
        }
        return DataType.suggestedCast(originalTypes.stream().map(DataType::fromTypeName).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public ColumnInfoImpl(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = DataType.fromEs((String)in.readString());
        if (in.getTransportVersion().supports(ESQL_REPORT_ORIGINAL_TYPES)) {
            this.originalTypes = in.readOptionalStringCollectionAsList();
            this.suggestedCast = ColumnInfoImpl.calculateSuggestedCast(this.originalTypes);
        } else {
            this.originalTypes = null;
            this.suggestedCast = null;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type.outputType());
        if (out.getTransportVersion().supports(ESQL_REPORT_ORIGINAL_TYPES)) {
            out.writeOptionalStringCollection(this.originalTypes);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("type", this.type.outputType());
        if (this.originalTypes != null) {
            builder.field("original_types", this.originalTypes);
        }
        if (this.suggestedCast != null) {
            builder.field("suggested_cast", this.suggestedCast.typeName());
        }
        builder.endObject();
        return builder;
    }

    public String name() {
        return this.name;
    }

    public String outputType() {
        return this.type.outputType();
    }

    public DataType type() {
        return this.type;
    }

    @Nullable
    public List<String> originalTypes() {
        return this.originalTypes;
    }

    public String toString() {
        return "ColumnInfoImpl{name='" + this.name + "', type=" + String.valueOf(this.type) + ", originalTypes=" + String.valueOf(this.originalTypes) + "}";
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"esql/column_info", (boolean)true, ColumnInfoImpl.class);
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("original_types", new String[0]));
        PARSER = parser.build();
        ESQL_REPORT_ORIGINAL_TYPES = TransportVersion.fromName((String)"esql_report_original_types");
    }
}

