/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class TemplateParamValidator
implements ToXContentObject,
Writeable {
    private static final SpecVersion.VersionFlag SCHEMA_VERSION = SpecVersion.VersionFlag.V7;
    private static final JsonSchemaFactory SCHEMA_FACTORY = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SCHEMA_VERSION);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final JsonSchema META_SCHEMA = SCHEMA_FACTORY.getSchema(TemplateParamValidator.class.getResourceAsStream("json-schema-draft-07.json"));
    private final JsonSchema jsonSchema;

    public TemplateParamValidator(StreamInput in) throws IOException {
        this(in.readString());
    }

    public TemplateParamValidator(String dictionaryContent) throws ValidationException {
        try {
            JsonNode schemaJsonNode = OBJECT_MAPPER.readTree(dictionaryContent);
            TemplateParamValidator.validateWithSchema(META_SCHEMA, schemaJsonNode);
            this.jsonSchema = SCHEMA_FACTORY.getSchema(schemaJsonNode);
        }
        catch (JsonProcessingException e) {
            throw new ValidationException().addValidationError(e.getMessage());
        }
    }

    public TemplateParamValidator(XContentBuilder xContentBuilder) {
        this(Strings.toString((XContentBuilder)xContentBuilder));
    }

    private static void validateWithSchema(JsonSchema jsonSchema, JsonNode jsonNode) {
        Set validationMessages = jsonSchema.validate(jsonNode);
        if (!validationMessages.isEmpty()) {
            ValidationException validationException = new ValidationException();
            for (ValidationMessage message : validationMessages) {
                validationException.addValidationError(message.getMessage());
            }
            throw validationException;
        }
    }

    public void validate(Map<String, Object> templateParams) throws ValidationException {
        JsonNode secondParam = null;
        try {
            SpecialPermission.check();
            secondParam = AccessController.doPrivileged(() -> OBJECT_MAPPER.valueToTree((Object)templateParams));
        }
        catch (PrivilegedActionException e) {
            throw new ElasticsearchStatusException("failed to convert parameters while validating", RestStatus.INTERNAL_SERVER_ERROR, e.getCause(), new Object[0]);
        }
        TemplateParamValidator.validateWithSchema(this.jsonSchema, secondParam);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContent xContent = XContentType.JSON.xContent();
        try (XContentParser parser = xContent.createParser(XContentParserConfiguration.EMPTY, this.getSchemaPropertiesAsString());){
            builder.copyCurrentStructure(parser);
        }
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getSchemaPropertiesAsString());
    }

    private String getSchemaPropertiesAsString() {
        return this.jsonSchema.getSchemaNode().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateParamValidator that = (TemplateParamValidator)o;
        return Objects.equals(this.getSchemaPropertiesAsString(), that.getSchemaPropertiesAsString());
    }

    public int hashCode() {
        return Objects.hash(this.getSchemaPropertiesAsString());
    }
}

