/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.GetInferenceDiagnosticsAction;
import org.elasticsearch.xpack.inference.external.http.HttpClientManager;
import org.elasticsearch.xpack.inference.registry.InferenceEndpointRegistry;

public class TransportGetInferenceDiagnosticsAction
extends TransportNodesAction<GetInferenceDiagnosticsAction.Request, GetInferenceDiagnosticsAction.Response, GetInferenceDiagnosticsAction.NodeRequest, GetInferenceDiagnosticsAction.NodeResponse, Void> {
    private final ClientManagers managers;
    private final InferenceEndpointRegistry inferenceEndpointRegistry;

    @Inject
    public TransportGetInferenceDiagnosticsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ClientManagers managers, InferenceEndpointRegistry inferenceEndpointRegistry) {
        super("cluster:monitor/xpack/inference/diagnostics/get", clusterService, transportService, actionFilters, GetInferenceDiagnosticsAction.NodeRequest::new, (Executor)threadPool.executor("management"));
        this.managers = Objects.requireNonNull(managers);
        this.inferenceEndpointRegistry = Objects.requireNonNull(inferenceEndpointRegistry);
    }

    protected GetInferenceDiagnosticsAction.Response newResponse(GetInferenceDiagnosticsAction.Request request, List<GetInferenceDiagnosticsAction.NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new GetInferenceDiagnosticsAction.Response(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected GetInferenceDiagnosticsAction.NodeRequest newNodeRequest(GetInferenceDiagnosticsAction.Request request) {
        return new GetInferenceDiagnosticsAction.NodeRequest();
    }

    protected GetInferenceDiagnosticsAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new GetInferenceDiagnosticsAction.NodeResponse(in);
    }

    protected GetInferenceDiagnosticsAction.NodeResponse nodeOperation(GetInferenceDiagnosticsAction.NodeRequest request, Task task) {
        return new GetInferenceDiagnosticsAction.NodeResponse(this.transportService.getLocalNode(), this.managers.externalHttpClientManager().getPoolStats(), this.managers.eisMtlsHttpClientManager().getPoolStats(), this.cacheStats());
    }

    private GetInferenceDiagnosticsAction.NodeResponse.Stats cacheStats() {
        if (this.inferenceEndpointRegistry.cacheEnabled()) {
            Cache.Stats stats = this.inferenceEndpointRegistry.stats();
            return new GetInferenceDiagnosticsAction.NodeResponse.Stats(this.inferenceEndpointRegistry.cacheCount(), stats.getHits(), stats.getMisses(), stats.getEvictions());
        }
        return null;
    }

    public record ClientManagers(HttpClientManager externalHttpClientManager, HttpClientManager eisMtlsHttpClientManager) {
    }
}

