/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.gax.paging.Page;
import com.google.api.services.storage.Storage;
import com.google.cloud.ReadChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.HttpStorageRpc;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.stream.Stream;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.repositories.gcs.GcsRepositoryStatsCollector;
import org.elasticsearch.repositories.gcs.OperationStats;
import org.elasticsearch.repositories.gcs.StorageOperation;

public class MeteredStorage {
    private final Storage storage;
    private final com.google.api.services.storage.Storage storageRpc;
    private final GcsRepositoryStatsCollector statsCollector;

    public MeteredStorage(Storage storage, GcsRepositoryStatsCollector statsCollector) {
        this.storage = storage;
        SpecialPermission.check();
        this.storageRpc = MeteredStorage.getStorageRpc(storage);
        this.statsCollector = statsCollector;
    }

    MeteredStorage(Storage storage, com.google.api.services.storage.Storage storageRpc, GcsRepositoryStatsCollector statsCollector) {
        this.storage = storage;
        this.storageRpc = storageRpc;
        this.statsCollector = statsCollector;
    }

    @SuppressForbidden(reason="need access to storage client")
    private static com.google.api.services.storage.Storage getStorageRpc(Storage client) {
        assert (((StorageOptions)client.getOptions()).getRpc() instanceof HttpStorageRpc);
        assert (Stream.of(((StorageOptions)client.getOptions()).getRpc().getClass().getDeclaredFields()).anyMatch(f -> f.getName().equals("storage")));
        try {
            Field storageField = ((StorageOptions)client.getOptions()).getRpc().getClass().getDeclaredField("storage");
            storageField.setAccessible(true);
            return (com.google.api.services.storage.Storage)storageField.get(((StorageOptions)client.getOptions()).getRpc());
        }
        catch (Exception e) {
            throw new IllegalStateException("storage could not be set up", e);
        }
    }

    public MeteredBlobPage meteredList(OperationPurpose purpose, String bucket, Storage.BlobListOption ... options) throws IOException {
        Page pages = this.statsCollector.collectSupplier(purpose, StorageOperation.LIST, () -> this.storage.list(bucket, options));
        return new MeteredBlobPage(this.statsCollector, purpose, (Page<Blob>)pages);
    }

    public Blob meteredGet(OperationPurpose purpose, BlobId blobId) throws IOException {
        return (Blob)this.statsCollector.collectIOSupplier(purpose, StorageOperation.GET, () -> this.storage.get(blobId));
    }

    public void meteredCreate(OperationPurpose purpose, BlobInfo blobInfo, byte[] buffer, int offset, int blobSize, Storage.BlobTargetOption ... targetOptions) throws IOException {
        this.statsCollector.collectIOSupplier(purpose, StorageOperation.INSERT, () -> this.storage.create(blobInfo, buffer, offset, blobSize, targetOptions));
    }

    public StorageBatch batch() {
        return this.storage.batch();
    }

    public StorageOptions getOptions() {
        return (StorageOptions)this.storage.getOptions();
    }

    public MeteredObjectsGetRequest meteredObjectsGet(OperationPurpose purpose, String bucket, String blob) throws IOException {
        return new MeteredObjectsGetRequest(this.statsCollector, purpose, this.storageRpc.objects().get(bucket, blob));
    }

    public MeteredWriteChannel meteredWriter(OperationPurpose purpose, BlobInfo blobInfo, Storage.BlobWriteOption ... writeOptions) throws IOException {
        OperationStats initStats = new OperationStats(purpose, StorageOperation.INSERT);
        return (MeteredWriteChannel)this.statsCollector.continueWithStats(initStats, () -> new MeteredWriteChannel(this.statsCollector, initStats, this.storage.writer(blobInfo, writeOptions)));
    }

    public MeteredReadChannel meteredReader(OperationPurpose purpose, BlobId blobId, Storage.BlobSourceOption ... options) {
        return new MeteredReadChannel(purpose, this.statsCollector, this.storage.reader(blobId, options));
    }

    public static class MeteredBlobPage
    implements Page<Blob> {
        private final GcsRepositoryStatsCollector statsCollector;
        private final OperationPurpose purpose;
        private final Page<Blob> pages;

        public MeteredBlobPage(GcsRepositoryStatsCollector statsCollector, OperationPurpose purpose, Page<Blob> pages) {
            this.statsCollector = statsCollector;
            this.purpose = purpose;
            this.pages = pages;
        }

        public boolean hasNextPage() {
            return this.pages.hasNextPage();
        }

        public String getNextPageToken() {
            return this.pages.getNextPageToken();
        }

        public MeteredBlobPage getNextPage() {
            Page nextPage = this.statsCollector.collectSupplier(this.purpose, StorageOperation.LIST, () -> this.pages.getNextPage());
            if (nextPage != null) {
                return new MeteredBlobPage(this.statsCollector, this.purpose, (Page<Blob>)nextPage);
            }
            return null;
        }

        public MeteredIterableBlob iterateAll() {
            return new MeteredIterableBlob(this.pages.iterateAll());
        }

        public MeteredIterableBlob getValues() {
            return new MeteredIterableBlob(this.pages.getValues());
        }

        public class MeteredIterableBlob
        implements Iterable<Blob> {
            final Iterable<Blob> iterable;

            MeteredIterableBlob(Iterable<Blob> iterable) {
                this.iterable = iterable;
            }

            @Override
            public Iterator<Blob> iterator() {
                return new MeteredIterator(this.iterable.iterator());
            }
        }

        public class MeteredIterator
        implements Iterator<Blob> {
            final Iterator<Blob> iterator;

            MeteredIterator(Iterator<Blob> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return MeteredBlobPage.this.statsCollector.collectSupplier(MeteredBlobPage.this.purpose, StorageOperation.LIST, this.iterator::hasNext);
            }

            @Override
            public Blob next() {
                return MeteredBlobPage.this.statsCollector.collectSupplier(MeteredBlobPage.this.purpose, StorageOperation.LIST, this.iterator::next);
            }
        }
    }

    public static class MeteredObjectsGetRequest {
        private final GcsRepositoryStatsCollector statsCollector;
        private final OperationPurpose purpose;
        private final Storage.Objects.Get get;

        MeteredObjectsGetRequest(GcsRepositoryStatsCollector statsCollector, OperationPurpose purpose, Storage.Objects.Get get) {
            this.statsCollector = statsCollector;
            this.purpose = purpose;
            this.get = get;
        }

        public void setReturnRawInputStream(boolean b) {
            this.get.setReturnRawInputStream(b);
        }

        public void setGeneration(Long generation) {
            this.get.setGeneration(generation);
        }

        public HttpHeaders getRequestHeaders() {
            return this.get.getRequestHeaders();
        }

        public HttpResponse executeMedia() throws IOException {
            return (HttpResponse)this.statsCollector.collectIOSupplier(this.purpose, StorageOperation.GET, () -> ((Storage.Objects.Get)this.get).executeMedia());
        }
    }

    @SuppressForbidden(reason="wraps GCS channel")
    public static class MeteredWriteChannel
    implements WriteChannel {
        private final GcsRepositoryStatsCollector statsCollector;
        private final WriteChannel writeChannel;
        private final OperationStats stats;

        public MeteredWriteChannel(GcsRepositoryStatsCollector statsCollector, OperationStats initStats, WriteChannel readChannel) {
            this.statsCollector = statsCollector;
            this.writeChannel = readChannel;
            this.stats = initStats;
        }

        public void setChunkSize(int chunkSize) {
            this.writeChannel.setChunkSize(chunkSize);
        }

        public RestorableState<WriteChannel> capture() {
            return () -> new MeteredWriteChannel(this.statsCollector, this.stats, (WriteChannel)this.writeChannel.capture().restore());
        }

        public int write(ByteBuffer src) throws IOException {
            return (Integer)this.statsCollector.continueWithStats(this.stats, () -> this.writeChannel.write(src));
        }

        public boolean isOpen() {
            return this.writeChannel.isOpen();
        }

        public void close() throws IOException {
            this.statsCollector.finishRunnable(this.stats, () -> this.writeChannel.close());
        }
    }

    @SuppressForbidden(reason="wraps GCS channel")
    public static class MeteredReadChannel
    implements ReadChannel {
        private final GcsRepositoryStatsCollector statsCollector;
        private final ReadChannel readChannel;
        private final OperationPurpose purpose;

        MeteredReadChannel(OperationPurpose purpose, GcsRepositoryStatsCollector statsCollector, ReadChannel readChannel) {
            this.statsCollector = statsCollector;
            this.readChannel = readChannel;
            this.purpose = purpose;
        }

        public void close() {
            this.statsCollector.collectRunnable(this.purpose, StorageOperation.GET, () -> ((ReadChannel)this.readChannel).close());
        }

        public void seek(long position) throws IOException {
            this.statsCollector.collectIORunnable(this.purpose, StorageOperation.GET, () -> this.readChannel.seek(position));
        }

        public void setChunkSize(int chunkSize) {
            this.readChannel.setChunkSize(chunkSize);
        }

        public RestorableState<ReadChannel> capture() {
            return () -> new MeteredReadChannel(this.purpose, this.statsCollector, (ReadChannel)this.readChannel.capture().restore());
        }

        public ReadChannel limit(long limit) {
            this.readChannel.limit(limit);
            return this;
        }

        public long limit() {
            return this.readChannel.limit();
        }

        public int read(ByteBuffer dst) throws IOException {
            return (Integer)this.statsCollector.collectIOSupplier(this.purpose, StorageOperation.GET, () -> this.readChannel.read(dst));
        }

        public boolean isOpen() {
            return this.readChannel.isOpen();
        }
    }
}

