/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.session;

import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.eql.action.EqlSearchTask;
import org.elasticsearch.xpack.ql.session.Configuration;

public class EqlConfiguration
extends Configuration {
    private final String[] indices;
    private final TimeValue requestTimeout;
    private final String clientId;
    private final IndicesOptions indicesOptions;
    private final TaskId taskId;
    private final EqlSearchTask task;
    private final int fetchSize;
    private final int maxSamplesPerKey;
    private final boolean allowPartialSearchResults;
    private final boolean allowPartialSequenceResults;
    @Nullable
    private final QueryBuilder filter;
    @Nullable
    private final List<FieldAndFormat> fetchFields;
    @Nullable
    private Map<String, Object> runtimeMappings;

    public EqlConfiguration(String[] indices, ZoneId zi, String username, String clusterName, QueryBuilder filter, Map<String, Object> runtimeMappings, List<FieldAndFormat> fetchFields, TimeValue requestTimeout, IndicesOptions indicesOptions, int fetchSize, int maxSamplesPerKey, boolean allowPartialSearchResults, boolean allowPartialSequenceResults, String clientId, TaskId taskId, EqlSearchTask task) {
        super(zi, username, clusterName);
        this.indices = indices;
        this.filter = filter;
        this.runtimeMappings = runtimeMappings;
        this.fetchFields = fetchFields;
        this.requestTimeout = requestTimeout;
        this.clientId = clientId;
        this.indicesOptions = indicesOptions;
        this.taskId = taskId;
        this.task = task;
        this.fetchSize = fetchSize;
        this.maxSamplesPerKey = maxSamplesPerKey;
        this.allowPartialSearchResults = allowPartialSearchResults;
        this.allowPartialSequenceResults = allowPartialSequenceResults;
    }

    public String[] indices() {
        return this.indices;
    }

    public String indexAsWildcard() {
        return Strings.arrayToCommaDelimitedString((Object[])this.indices);
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public int maxSamplesPerKey() {
        return this.maxSamplesPerKey;
    }

    public boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public boolean allowPartialSequenceResults() {
        return this.allowPartialSequenceResults;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public Map<String, Object> runtimeMappings() {
        return this.runtimeMappings;
    }

    public List<FieldAndFormat> fetchFields() {
        return this.fetchFields;
    }

    public String clientId() {
        return this.clientId;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    public TaskId getTaskId() {
        return this.taskId;
    }
}

