/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank.feature;

import java.util.Arrays;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.search.SearchContextSourcePrinter;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchFieldsContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankShardContext;
import org.elasticsearch.search.rank.feature.RankFeatureDoc;
import org.elasticsearch.search.rank.feature.RankFeatureShardRequest;
import org.elasticsearch.search.rank.feature.RankFeatureShardResult;
import org.elasticsearch.tasks.TaskCancelledException;

public final class RankFeatureShardPhase {
    private static final Logger logger = LogManager.getLogger(RankFeatureShardPhase.class);
    public static final RankFeatureShardResult EMPTY_RESULT = new RankFeatureShardResult(new RankFeatureDoc[0]);

    private RankFeatureShardPhase() {
    }

    public static void prepareForFetch(SearchContext searchContext, RankFeatureShardRequest request) {
        if (logger.isTraceEnabled()) {
            logger.trace("{}", (Object)new SearchContextSourcePrinter(searchContext));
        }
        if (searchContext.isCancelled()) {
            throw new TaskCancelledException("cancelled");
        }
        RankFeaturePhaseRankShardContext rankFeaturePhaseRankShardContext = RankFeatureShardPhase.shardContext(searchContext);
        if (rankFeaturePhaseRankShardContext != null) {
            String field = rankFeaturePhaseRankShardContext.getField();
            assert (field != null) : "field must not be null";
            searchContext.fetchFieldsContext(new FetchFieldsContext(Collections.singletonList(new FieldAndFormat(field, null))));
            rankFeaturePhaseRankShardContext.prepareForFetch(searchContext);
            searchContext.storedFieldsContext(StoredFieldsContext.fromList(Collections.singletonList("_none_")));
            searchContext.addFetchResult();
            Arrays.sort(request.getDocIds());
        }
    }

    public static void processFetch(SearchContext searchContext) {
        RankFeaturePhaseRankShardContext rankFeaturePhaseRankShardContext;
        if (logger.isTraceEnabled()) {
            logger.trace("{}", (Object)new SearchContextSourcePrinter(searchContext));
        }
        if (searchContext.isCancelled()) {
            throw new TaskCancelledException("cancelled");
        }
        RankFeaturePhaseRankShardContext rankFeaturePhaseRankShardContext2 = rankFeaturePhaseRankShardContext = searchContext.request().source().rankBuilder() != null ? searchContext.request().source().rankBuilder().buildRankFeaturePhaseShardContext() : null;
        if (rankFeaturePhaseRankShardContext != null) {
            FetchSearchResult fetchSearchResult = searchContext.fetchResult();
            if (fetchSearchResult == null || fetchSearchResult.hits() == null) {
                return;
            }
            SearchHits hits = fetchSearchResult.hits();
            RankFeatureShardResult featureRankShardResult = (RankFeatureShardResult)rankFeaturePhaseRankShardContext.buildRankFeatureShardResult(hits, searchContext.request().shardRequestIndex());
            if (featureRankShardResult != null) {
                searchContext.rankFeatureResult().shardResult(featureRankShardResult);
            }
        }
    }

    private static RankFeaturePhaseRankShardContext shardContext(SearchContext searchContext) {
        return searchContext.request().source() != null && searchContext.request().source().rankBuilder() != null ? searchContext.request().source().rankBuilder().buildRankFeaturePhaseShardContext() : null;
    }
}

