/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;

public abstract class BaseRestHandler
implements RestHandler {
    public static final Setting<Boolean> MULTI_ALLOW_EXPLICIT_INDEX = Setting.boolSetting("rest.action.multi.allow_explicit_index", true, Setting.Property.NodeScope);
    private final LongAdder usageCount = new LongAdder();
    private static final Set<String> ALWAYS_SUPPORTED = Set.of("format", "filter_path", "pretty", "human");

    public final long getUsageCount() {
        return this.usageCount.sum();
    }

    @Override
    public abstract String getName();

    @Override
    public abstract List<RestHandler.Route> routes();

    @Override
    public final void handleRequest(RestRequest request, final RestChannel channel, NodeClient client) throws Exception {
        Set<String> allSupported;
        Set<String> supported = this.allSupportedParameters();
        assert (supported == this.allSupportedParameters()) : this.getName() + ": did not return same instance from allSupportedParameters()";
        if (supported != null && !(allSupported = Sets.union(RestResponse.RESPONSE_PARAMS, ALWAYS_SUPPORTED, RestRequest.INTERNAL_MARKER_REQUEST_PARAMETERS, supported)).containsAll(request.params().keySet())) {
            Set<String> unsupported = Sets.difference(request.params().keySet(), allSupported);
            throw new IllegalArgumentException(BaseRestHandler.unrecognized(request, unsupported, allSupported, "parameter"));
        }
        try (RestChannelConsumer action = this.prepareRequest(request, client);){
            assert (this.assertConsumesSupportedParams(supported, request));
            SortedSet unconsumedParams = request.unconsumedParams().stream().filter(p -> !RestResponse.RESPONSE_PARAMS.contains(p)).filter(p -> !this.responseParams(request.getRestApiVersion()).contains(p)).collect(Collectors.toCollection(TreeSet::new));
            if (!unconsumedParams.isEmpty()) {
                HashSet<String> candidateParams = new HashSet<String>();
                candidateParams.addAll(request.consumedParams());
                candidateParams.addAll(this.responseParams(request.getRestApiVersion()));
                throw new IllegalArgumentException(BaseRestHandler.unrecognized(request, unconsumedParams, candidateParams, "parameter"));
            }
            if (request.hasContent() && !request.isContentConsumed() && request.isFullContent()) {
                throw new IllegalArgumentException("request [" + String.valueOf((Object)request.method()) + " " + request.path() + "] does not support having a body");
            }
            this.usageCount.increment();
            if (request.isStreamedContent()) {
                assert (action instanceof RequestBodyChunkConsumer);
                final RequestBodyChunkConsumer chunkConsumer = (RequestBodyChunkConsumer)action;
                request.contentStream().setHandler(new HttpBody.ChunkHandler(){

                    @Override
                    public void onNext(ReleasableBytesReference chunk, boolean isLast) {
                        chunkConsumer.handleChunk(channel, chunk, isLast);
                    }

                    @Override
                    public void close() {
                        chunkConsumer.streamClose();
                    }
                });
                action.accept(channel);
            } else {
                action.accept(channel);
                request.getHttpRequest().release();
            }
        }
    }

    private boolean assertConsumesSupportedParams(@Nullable Set<String> supported, RestRequest request) {
        if (supported != null) {
            TreeSet<String> supportedAndCommon = new TreeSet<String>(supported);
            supportedAndCommon.add("error_trace");
            supportedAndCommon.addAll(ALWAYS_SUPPORTED);
            supportedAndCommon.removeAll(RestRequest.INTERNAL_MARKER_REQUEST_PARAMETERS);
            TreeSet<String> consumed = new TreeSet<String>(request.consumedParams());
            consumed.removeAll(RestRequest.INTERNAL_MARKER_REQUEST_PARAMETERS);
            consumed.addAll(this.responseParams(request.getRestApiVersion()));
            assert (supportedAndCommon.equals(consumed)) : this.getName() + ": consumed params " + String.valueOf(consumed) + " while supporting " + String.valueOf(supportedAndCommon);
        }
        return true;
    }

    protected static String unrecognized(RestRequest request, Set<String> invalids, Set<String> candidates, String detail) {
        StringBuilder message = new StringBuilder().append("request [").append(request.path()).append("] contains unrecognized ").append(detail).append(invalids.size() > 1 ? "s" : "").append(": ");
        Iterator<String> it = invalids.iterator();
        while (it.hasNext()) {
            String invalid = it.next();
            LevenshteinDistance ld = new LevenshteinDistance();
            List<String> candidateParams = candidates.stream().map(c -> Tuple.tuple((Object)Float.valueOf(ld.getDistance(invalid, c)), (Object)c)).filter(t -> ((Float)t.v1()).floatValue() > 0.5f).sorted(Comparator.comparing(Tuple::v1).reversed().thenComparing(Tuple::v2)).map(Tuple::v2).toList();
            message.append("[").append(invalid).append("]");
            if (!candidateParams.isEmpty()) {
                message.append(" -> did you mean ");
                if (candidateParams.size() > 1) {
                    message.append("any of ");
                }
                message.append(candidateParams);
                message.append("?");
            }
            if (!it.hasNext()) continue;
            message.append(", ");
        }
        return message.toString();
    }

    protected abstract RestChannelConsumer prepareRequest(RestRequest var1, NodeClient var2) throws IOException;

    protected Set<String> responseParams() {
        return Collections.emptySet();
    }

    protected Set<String> responseParams(RestApiVersion restApiVersion) {
        return this.responseParams();
    }

    @FunctionalInterface
    protected static interface RestChannelConsumer
    extends CheckedConsumer<RestChannel, Exception>,
    Releasable {
        default public void close() {
        }
    }

    public static interface RequestBodyChunkConsumer
    extends RestChannelConsumer {
        public void handleChunk(RestChannel var1, ReleasableBytesReference var2, boolean var3);

        default public void streamClose() {
        }
    }
}

