/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.reservedstate.service.ErrorState;
import org.elasticsearch.reservedstate.service.ReservedClusterStateService;
import org.elasticsearch.reservedstate.service.ReservedStateChunk;
import org.elasticsearch.reservedstate.service.ReservedStateUpdateTask;
import org.elasticsearch.reservedstate.service.ReservedStateVersionCheck;

public class ReservedClusterStateUpdateTask
extends ReservedStateUpdateTask<ReservedClusterStateHandler<?>> {
    public ReservedClusterStateUpdateTask(String namespace, ReservedStateChunk stateChunk, ReservedStateVersionCheck versionCheck, Map<String, ReservedClusterStateHandler<?>> handlers, Collection<String> orderedHandlers, Consumer<ErrorState> errorReporter, ActionListener<ActionResponse.Empty> listener) {
        super(namespace, stateChunk, versionCheck, handlers, orderedHandlers, errorReporter, listener);
    }

    @Override
    protected Optional<ProjectId> projectId() {
        return Optional.empty();
    }

    @Override
    protected TransformState transform(ReservedClusterStateHandler<?> handler, Object state, TransformState transformState) throws Exception {
        return ReservedClusterStateService.transform(handler, state, transformState);
    }

    @Override
    ClusterState execute(ClusterState currentState) {
        if (currentState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return currentState;
        }
        Tuple<ClusterState, ReservedStateMetadata> result = this.execute(currentState, currentState.getMetadata().reservedStateMetadata());
        if (result == null) {
            return currentState;
        }
        return ClusterState.builder((ClusterState)result.v1()).metadata(Metadata.builder(((ClusterState)result.v1()).metadata()).put((ReservedStateMetadata)result.v2())).build();
    }
}

