/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.Index;

public final class IndexNotFoundException
extends ResourceNotFoundException {
    public IndexNotFoundException(String message, String index) {
        super("no such index [" + index + "] and " + message, new Object[0]);
        this.setIndex(index);
    }

    public IndexNotFoundException(String message, Index index) {
        super("no such index [" + String.valueOf(index) + "] and " + message, new Object[0]);
        this.setIndex(index);
    }

    public IndexNotFoundException(String index) {
        this(index, (Throwable)null);
    }

    public IndexNotFoundException(String index, Throwable cause) {
        super("no such index [" + index + "]", cause, new Object[0]);
        this.setIndex(index);
    }

    public IndexNotFoundException(Index index, ProjectId id) {
        super("no such index [" + index.getName() + "] in project [" + String.valueOf(id) + "]", new Object[0]);
        this.setIndex(index);
    }

    public IndexNotFoundException(Index index) {
        this(index, (Throwable)null);
    }

    public IndexNotFoundException(Index index, Throwable cause) {
        super("no such index [" + index.getName() + "]", cause, new Object[0]);
        this.setIndex(index);
    }

    public IndexNotFoundException(StreamInput in) throws IOException {
        super(in);
    }
}

