/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.health.node.DataStreamLifecycleHealthInfo;
import org.elasticsearch.health.node.DiskHealthInfo;
import org.elasticsearch.health.node.RepositoriesHealthInfo;
import org.elasticsearch.reservedstate.service.FileSettingsService;

public record HealthInfo(Map<String, DiskHealthInfo> diskInfoByNode, @Nullable DataStreamLifecycleHealthInfo dslHealthInfo, Map<String, RepositoriesHealthInfo> repositoriesInfoByNode, FileSettingsService.FileSettingsHealthInfo fileSettingsHealthInfo) implements Writeable
{
    public static final HealthInfo EMPTY_HEALTH_INFO = new HealthInfo(Map.of(), DataStreamLifecycleHealthInfo.NO_DSL_ERRORS, Map.of(), FileSettingsService.FileSettingsHealthInfo.INDETERMINATE);
    private static final TransportVersion FILE_SETTINGS_HEALTH_INFO = TransportVersion.fromName("file_settings_health_info");

    public HealthInfo {
        Objects.requireNonNull(fileSettingsHealthInfo);
    }

    public HealthInfo(StreamInput input) throws IOException {
        this(input.readMap(DiskHealthInfo::new), input.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? input.readOptionalWriteable(DataStreamLifecycleHealthInfo::new) : null, input.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0) ? input.readMap(RepositoriesHealthInfo::new) : Map.of(), input.getTransportVersion().supports(FILE_SETTINGS_HEALTH_INFO) ? input.readOptionalWriteable(FileSettingsService.FileSettingsHealthInfo::new) : FileSettingsService.FileSettingsHealthInfo.INDETERMINATE);
    }

    @Override
    public void writeTo(StreamOutput output) throws IOException {
        output.writeMap(this.diskInfoByNode, StreamOutput::writeWriteable);
        if (output.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            output.writeOptionalWriteable(this.dslHealthInfo);
        }
        if (output.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
            output.writeMap(this.repositoriesInfoByNode, StreamOutput::writeWriteable);
        }
        if (output.getTransportVersion().supports(FILE_SETTINGS_HEALTH_INFO)) {
            output.writeOptionalWriteable(this.fileSettingsHealthInfo);
        }
    }
}

