/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureClusterStateSettings;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.xcontent.ToXContent;

public class ProjectSecrets
extends AbstractNamedDiffable<Metadata.ProjectCustom>
implements Metadata.ProjectCustom {
    public static final String TYPE = "project_state_secrets";
    private static final TransportVersion MULTI_PROJECT = TransportVersion.fromName("multi_project");
    private final SecureClusterStateSettings settings;

    public ProjectSecrets(SecureClusterStateSettings settings) {
        this.settings = settings;
    }

    public ProjectSecrets(StreamInput in) throws IOException {
        this.settings = new SecureClusterStateSettings(in);
    }

    public SecureSettings getSettings() {
        return new SecureClusterStateSettings(this.settings);
    }

    public Set<String> getSettingNames() {
        return Collections.unmodifiableSet(this.settings.getSettingNames());
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Collections.emptyIterator();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return MULTI_PROJECT;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.settings.writeTo(out);
    }

    public static NamedDiff<Metadata.ProjectCustom> readDiffFrom(StreamInput in) throws IOException {
        return ProjectSecrets.readDiffFrom(Metadata.ProjectCustom.class, TYPE, in);
    }

    public String toString() {
        return "ProjectSecrets{[all secret]}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectSecrets that = (ProjectSecrets)o;
        return Objects.equals(this.settings, that.settings);
    }

    public int hashCode() {
        return Objects.hash(this.settings);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.noneOf(Metadata.XContentContext.class);
    }
}

