/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.util.TreeMap;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramCircuitBreaker;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramUtils;
import org.elasticsearch.exponentialhistogram.FixedCapacityExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ReleasableExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ZeroBucket;

public class ExponentialHistogramBuilder {
    private final ExponentialHistogramCircuitBreaker breaker;
    private int scale;
    private ZeroBucket zeroBucket = ZeroBucket.minimalEmpty();
    private Double sum;
    private Double min;
    private Double max;
    private final TreeMap<Long, Long> negativeBuckets = new TreeMap();
    private final TreeMap<Long, Long> positiveBuckets = new TreeMap();

    ExponentialHistogramBuilder(int scale, ExponentialHistogramCircuitBreaker breaker) {
        this.breaker = breaker;
        this.scale = scale;
    }

    ExponentialHistogramBuilder(ExponentialHistogram toCopy, ExponentialHistogramCircuitBreaker breaker) {
        this(toCopy.scale(), breaker);
        this.zeroBucket(toCopy.zeroBucket());
        this.sum(toCopy.sum());
        this.min(toCopy.min());
        this.max(toCopy.max());
        CopyableBucketIterator negBuckets = toCopy.negativeBuckets().iterator();
        while (negBuckets.hasNext()) {
            this.setNegativeBucket(negBuckets.peekIndex(), negBuckets.peekCount());
            negBuckets.advance();
        }
        CopyableBucketIterator posBuckets = toCopy.positiveBuckets().iterator();
        while (posBuckets.hasNext()) {
            this.setPositiveBucket(posBuckets.peekIndex(), posBuckets.peekCount());
            posBuckets.advance();
        }
    }

    public ExponentialHistogramBuilder scale(int scale) {
        this.scale = scale;
        return this;
    }

    public ExponentialHistogramBuilder zeroBucket(ZeroBucket zeroBucket) {
        this.zeroBucket = zeroBucket;
        return this;
    }

    public ExponentialHistogramBuilder sum(double sum) {
        this.sum = sum;
        return this;
    }

    public ExponentialHistogramBuilder min(double min) {
        this.min = min;
        return this;
    }

    public ExponentialHistogramBuilder max(double max) {
        this.max = max;
        return this;
    }

    public ExponentialHistogramBuilder setPositiveBucket(long index, long count) {
        if (count < 1L) {
            throw new IllegalArgumentException("Bucket count must be at least 1");
        }
        this.positiveBuckets.put(index, count);
        return this;
    }

    public ExponentialHistogramBuilder setNegativeBucket(long index, long count) {
        if (count < 1L) {
            throw new IllegalArgumentException("Bucket count must be at least 1");
        }
        this.negativeBuckets.put(index, count);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReleasableExponentialHistogram build() {
        FixedCapacityExponentialHistogram result = FixedCapacityExponentialHistogram.create(this.negativeBuckets.size() + this.positiveBuckets.size(), this.breaker);
        boolean success = false;
        try {
            result.resetBuckets(this.scale);
            result.setZeroBucket(this.zeroBucket);
            this.negativeBuckets.forEach((index, count) -> result.tryAddBucket((long)index, (long)count, false));
            this.positiveBuckets.forEach((index, count) -> result.tryAddBucket((long)index, (long)count, true));
            double sumVal = this.sum != null ? this.sum : ExponentialHistogramUtils.estimateSum(result.negativeBuckets().iterator(), result.positiveBuckets().iterator());
            double minVal = this.min != null ? this.min.doubleValue() : ExponentialHistogramUtils.estimateMin(this.zeroBucket, result.negativeBuckets(), result.positiveBuckets()).orElse(Double.NaN);
            double maxVal = this.max != null ? this.max.doubleValue() : ExponentialHistogramUtils.estimateMax(this.zeroBucket, result.negativeBuckets(), result.positiveBuckets()).orElse(Double.NaN);
            result.setMin(minVal);
            result.setMax(maxVal);
            result.setSum(sumVal);
            success = true;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable)result);
            }
        }
        return result;
    }
}

