/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.join;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;

public record JoinConfig(JoinType type, List<Attribute> leftFields, List<Attribute> rightFields, @Nullable Expression joinOnConditions) implements Writeable
{
    private static final TransportVersion ESQL_LOOKUP_JOIN_ON_EXPRESSION = TransportVersion.fromName((String)"esql_lookup_join_on_expression");

    public JoinConfig(StreamInput in) throws IOException {
        this(JoinTypes.readFrom(in), JoinConfig.readLeftFields(in), in.readNamedWriteableCollectionAsList(Attribute.class), JoinConfig.readJoinConditions(in));
    }

    private static List<Attribute> readLeftFields(StreamInput in) throws IOException {
        if (!in.getTransportVersion().supports(ESQL_LOOKUP_JOIN_ON_EXPRESSION)) {
            in.readNamedWriteableCollectionAsList(Attribute.class);
        }
        return in.readNamedWriteableCollectionAsList(Attribute.class);
    }

    private static Expression readJoinConditions(StreamInput in) throws IOException {
        if (in.getTransportVersion().supports(ESQL_LOOKUP_JOIN_ON_EXPRESSION)) {
            return (Expression)in.readOptionalNamedWriteable(Expression.class);
        }
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.type.writeTo(out);
        if (!out.getTransportVersion().supports(ESQL_LOOKUP_JOIN_ON_EXPRESSION)) {
            out.writeNamedWriteableCollection(this.leftFields);
        }
        out.writeNamedWriteableCollection(this.leftFields);
        out.writeNamedWriteableCollection(this.rightFields);
        if (out.getTransportVersion().supports(ESQL_LOOKUP_JOIN_ON_EXPRESSION)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.joinOnConditions);
        } else if (this.joinOnConditions != null) {
            throw new IllegalArgumentException("LOOKUP JOIN with ON conditions is not supported on remote node");
        }
    }

    public boolean expressionsResolved() {
        return this.type.resolved() && Resolvables.resolved(this.leftFields) && Resolvables.resolved(this.rightFields) && (this.joinOnConditions == null || this.joinOnConditions.resolved());
    }

    @Override
    public String toString() {
        return "JoinConfig[type=" + String.valueOf(this.type) + ", leftFields=" + String.valueOf(this.leftFields) + ", rightFields=" + String.valueOf(this.rightFields) + ", joinOnConditions=" + String.valueOf(this.joinOnConditions) + "]";
    }
}

