/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.entitlement.runtime.api.NotEntitledException;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.PolicyChecker;
import org.elasticsearch.entitlement.runtime.policy.PolicyManager;
import org.elasticsearch.entitlement.runtime.policy.PolicyParser;
import org.elasticsearch.entitlement.runtime.policy.entitlements.CreateClassLoaderEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.Entitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ExitVMEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.InboundNetworkEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.LoadNativeLibrariesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ManageThreadsEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.OutboundNetworkEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ReadJdkImageEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ReadStoreAttributesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.SetHttpsConnectionPropertiesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.WriteSystemPropertiesEntitlement;

@SuppressForbidden(reason="Explicitly checking APIs that are forbidden")
public class PolicyCheckerImpl
implements PolicyChecker {
    protected final Set<Package> suppressFailureLogPackages;
    protected final Module entitlementsModule;
    private final PolicyManager policyManager;
    private final PathLookup pathLookup;
    private static final Set<String> NETWORK_PROTOCOLS = Set.of("http", "https", "ftp", "mailto");
    private static final List<String> ADDITIONAL_NETWORK_URL_CONNECT_CLASS_NAMES = List.of("sun.net.www.protocol.ftp.FtpURLConnection", "sun.net.www.protocol.mailto.MailToURLConnection");

    public PolicyCheckerImpl(Set<Package> suppressFailureLogPackages, Module entitlementsModule, PolicyManager policyManager, PathLookup pathLookup) {
        this.suppressFailureLogPackages = suppressFailureLogPackages;
        this.entitlementsModule = entitlementsModule;
        this.policyManager = policyManager;
        this.pathLookup = pathLookup;
    }

    private boolean isPathOnDefaultFilesystem(Path path) {
        if (!this.pathLookup.isPathOnDefaultFilesystem(path)) {
            PolicyManager.generalLogger.trace(() -> Strings.format((String)"File entitlement trivially allowed: path [%s] is for a different FileSystem class [%s], default is [%s]", (Object[])new Object[]{path.toString(), path.getFileSystem().getClass().getName(), PathLookup.DEFAULT_FILESYSTEM_CLASS.getName()}));
            return false;
        }
        return true;
    }

    private static String getModuleName(Class<?> requestingClass) {
        String name = requestingClass.getModule().getName();
        return name == null ? "ALL-UNNAMED" : name;
    }

    @Override
    public void checkStartProcess(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> "start process");
    }

    @Override
    public void checkWriteStoreAttributes(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> "change file store attributes");
    }

    @Override
    public void checkReadStoreAttributes(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, ReadStoreAttributesEntitlement.class);
    }

    private void neverEntitled(Class<?> callerClass, Supplier<String> operationDescription) {
        Class<?> requestingClass = this.requestingClass(callerClass);
        if (this.policyManager.isTriviallyAllowed(requestingClass)) {
            return;
        }
        PolicyManager.ModuleEntitlements entitlements = this.policyManager.getEntitlements(requestingClass);
        this.notEntitled(Strings.format((String)"component [%s], module [%s], class [%s], operation [%s]", (Object[])new Object[]{entitlements.componentName(), entitlements.moduleName(), requestingClass, operationDescription.get()}), requestingClass, entitlements);
    }

    @Override
    public void checkExitVM(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, ExitVMEntitlement.class);
    }

    @Override
    public void checkCreateClassLoader(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, CreateClassLoaderEntitlement.class);
    }

    @Override
    public void checkSetHttpsConnectionProperties(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, SetHttpsConnectionPropertiesEntitlement.class);
    }

    @Override
    public void checkChangeJVMGlobalState(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> this.walkStackForCheckMethodName().orElse("change JVM global state"));
    }

    @Override
    public void checkLoggingFileHandler(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> this.walkStackForCheckMethodName().orElse("create logging file handler"));
    }

    private Optional<String> walkStackForCheckMethodName() {
        return StackWalker.getInstance().walk(frames -> frames.map(StackWalker.StackFrame::getMethodName).dropWhile(Predicate.not(methodName -> methodName.startsWith("check$"))).findFirst()).map(this::operationDescription);
    }

    @Override
    public void checkChangeNetworkHandling(Class<?> callerClass) {
        this.checkChangeJVMGlobalState(callerClass);
    }

    @Override
    public void checkChangeFilesHandling(Class<?> callerClass) {
        this.checkChangeJVMGlobalState(callerClass);
    }

    @Override
    @SuppressForbidden(reason="Explicitly checking File apis")
    public void checkFileRead(Class<?> callerClass, File file) {
        this.checkFileRead(callerClass, file.toPath());
    }

    @Override
    public void checkFileRead(Class<?> callerClass, Path path) {
        try {
            this.checkFileRead(callerClass, path, false);
        }
        catch (NoSuchFileException e) {
            assert (false) : "NoSuchFileException should only be thrown when following links";
            NotEntitledException notEntitledException = new NotEntitledException(e.getMessage());
            notEntitledException.addSuppressed(e);
            throw notEntitledException;
        }
    }

    @Override
    public void checkFileRead(Class<?> callerClass, Path path, boolean followLinks) throws NoSuchFileException {
        if (!this.isPathOnDefaultFilesystem(path)) {
            return;
        }
        Class<?> requestingClass = this.requestingClass(callerClass);
        if (this.policyManager.isTriviallyAllowed(requestingClass)) {
            return;
        }
        PolicyManager.ModuleEntitlements entitlements = this.policyManager.getEntitlements(requestingClass);
        Path realPath = null;
        boolean canRead = entitlements.fileAccess().canRead(path);
        if (canRead && followLinks) {
            try {
                realPath = path.toRealPath(new LinkOption[0]);
                if (!realPath.equals(path)) {
                    canRead = entitlements.fileAccess().canRead(realPath);
                }
            }
            catch (NoSuchFileException e) {
                throw e;
            }
            catch (IOException e) {
                canRead = false;
            }
        }
        if (!canRead) {
            this.notEntitled(Strings.format((String)"component [%s], module [%s], class [%s], entitlement [file], operation [read], path [%s]", (Object[])new Object[]{entitlements.componentName(), entitlements.moduleName(), requestingClass, realPath == null ? path : Strings.format((String)"%s -> %s", (Object[])new Object[]{path, realPath})}), requestingClass, entitlements);
        }
    }

    @Override
    @SuppressForbidden(reason="Explicitly checking File apis")
    public void checkFileWrite(Class<?> callerClass, File file) {
        this.checkFileWrite(callerClass, file.toPath());
    }

    @Override
    public void checkFileWrite(Class<?> callerClass, Path path) {
        if (!this.isPathOnDefaultFilesystem(path)) {
            return;
        }
        Class<?> requestingClass = this.requestingClass(callerClass);
        if (this.policyManager.isTriviallyAllowed(requestingClass)) {
            return;
        }
        PolicyManager.ModuleEntitlements entitlements = this.policyManager.getEntitlements(requestingClass);
        if (!entitlements.fileAccess().canWrite(path)) {
            this.notEntitled(Strings.format((String)"component [%s], module [%s], class [%s], entitlement [file], operation [write], path [%s]", (Object[])new Object[]{entitlements.componentName(), entitlements.moduleName(), requestingClass, path}), requestingClass, entitlements);
        }
    }

    @Override
    @SuppressForbidden(reason="Explicitly checking File apis")
    public void checkFileWithZipMode(Class<?> callerClass, File file, int zipMode) {
        assert (zipMode == 1 || zipMode == 5);
        if ((zipMode & 4) == 4) {
            this.checkFileWrite(callerClass, file);
        } else {
            this.checkFileRead(callerClass, file);
        }
    }

    @Override
    public void checkCreateTempFile(Class<?> callerClass) {
        this.checkFileWrite(callerClass, this.pathLookup.getBaseDirPaths(PathLookup.BaseDir.TEMP).findFirst().get());
    }

    @Override
    public void checkFileDescriptorRead(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> "read file descriptor");
    }

    @Override
    public void checkFileDescriptorWrite(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> "write file descriptor");
    }

    @Override
    public void checkGetFileAttributeView(Class<?> callerClass) {
        this.neverEntitled(callerClass, () -> "get file attribute view");
    }

    @Override
    public void checkLoadingNativeLibraries(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, LoadNativeLibrariesEntitlement.class);
    }

    private String operationDescription(String methodName) {
        return methodName.substring(methodName.indexOf(36));
    }

    @Override
    public void checkInboundNetworkAccess(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, InboundNetworkEntitlement.class);
    }

    @Override
    public void checkOutboundNetworkAccess(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, OutboundNetworkEntitlement.class);
    }

    @Override
    public void checkAllNetworkAccess(Class<?> callerClass) {
        Class<?> requestingClass = this.requestingClass(callerClass);
        if (this.policyManager.isTriviallyAllowed(requestingClass)) {
            return;
        }
        PolicyManager.ModuleEntitlements classEntitlements = this.policyManager.getEntitlements(requestingClass);
        this.checkFlagEntitlement(classEntitlements, InboundNetworkEntitlement.class, requestingClass);
        this.checkFlagEntitlement(classEntitlements, OutboundNetworkEntitlement.class, requestingClass);
    }

    @Override
    public void checkUnsupportedURLProtocolConnection(Class<?> callerClass, String protocol) {
        this.neverEntitled(callerClass, () -> Strings.format((String)"unsupported URL protocol [%s]", (Object[])new Object[]{protocol}));
    }

    @Override
    public void checkWriteProperty(Class<?> callerClass, String property) {
        Class<?> requestingClass = this.requestingClass(callerClass);
        if (this.policyManager.isTriviallyAllowed(requestingClass)) {
            return;
        }
        PolicyManager.ModuleEntitlements entitlements = this.policyManager.getEntitlements(requestingClass);
        if (entitlements.getEntitlements(WriteSystemPropertiesEntitlement.class).anyMatch(e -> e.properties().contains(property))) {
            PolicyManager.generalLogger.debug(() -> Strings.format((String)"Entitled: component [%s], module [%s], class [%s], entitlement [write_system_properties], property [%s]", (Object[])new Object[]{entitlements.componentName(), entitlements.moduleName(), requestingClass, property}));
            return;
        }
        this.notEntitled(Strings.format((String)"component [%s], module [%s], class [%s], entitlement [write_system_properties], property [%s]", (Object[])new Object[]{entitlements.componentName(), entitlements.moduleName(), requestingClass, property}), requestingClass, entitlements);
    }

    @Override
    public void checkManageThreadsEntitlement(Class<?> callerClass) {
        this.checkEntitlementPresent(callerClass, ManageThreadsEntitlement.class);
    }

    Class<?> requestingClass(Class<?> callerClass) {
        if (callerClass != null) {
            return callerClass;
        }
        Optional result = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(frames -> this.findRequestingFrame((Stream<StackWalker.StackFrame>)frames).map(StackWalker.StackFrame::getDeclaringClass));
        return result.orElse(null);
    }

    Optional<StackWalker.StackFrame> findRequestingFrame(Stream<StackWalker.StackFrame> frames) {
        return frames.filter(f -> f.getDeclaringClass().getModule() != this.entitlementsModule).skip(1L).findFirst();
    }

    private void checkFlagEntitlement(PolicyManager.ModuleEntitlements classEntitlements, Class<? extends Entitlement> entitlementClass, Class<?> requestingClass) {
        if (!classEntitlements.hasEntitlement(entitlementClass)) {
            this.notEntitled(Strings.format((String)"component [%s], module [%s], class [%s], entitlement [%s]", (Object[])new Object[]{classEntitlements.componentName(), classEntitlements.moduleName(), requestingClass, PolicyParser.buildEntitlementNameFromClass(entitlementClass)}), requestingClass, classEntitlements);
        }
        PolicyManager.generalLogger.debug(() -> Strings.format((String)"Entitled: component [%s], module [%s], class [%s], entitlement [%s]", (Object[])new Object[]{classEntitlements.componentName(), classEntitlements.moduleName(), requestingClass, PolicyParser.buildEntitlementNameFromClass(entitlementClass)}));
    }

    private void notEntitled(String message, Class<?> requestingClass, PolicyManager.ModuleEntitlements entitlements) {
        NotEntitledException exception = new NotEntitledException(message);
        if (!this.suppressFailureLogPackages.contains(requestingClass.getPackage())) {
            entitlements.logger(requestingClass).warn("Not entitled: {}", new Object[]{message, exception});
        }
        throw exception;
    }

    @Override
    public void checkEntitlementPresent(Class<?> callerClass, Class<? extends Entitlement> entitlementClass) {
        Class<?> requestingClass = this.requestingClass(callerClass);
        if (this.policyManager.isTriviallyAllowed(requestingClass)) {
            return;
        }
        this.checkFlagEntitlement(this.policyManager.getEntitlements(requestingClass), entitlementClass, requestingClass);
    }

    @Override
    public void checkEntitlementForUrl(Class<?> callerClass, URL url) {
        if (this.handleNetworkOrFileUrlCheck(callerClass, url)) {
            return;
        }
        if (PolicyCheckerImpl.isJarUrl(url)) {
            URL jarFileUrl = this.extractJarFileUrl(url);
            if (jarFileUrl == null || !this.handleNetworkOrFileUrlCheck(callerClass, jarFileUrl)) {
                this.checkUnsupportedURLProtocolConnection(callerClass, "jar with unsupported inner protocol");
            }
        } else if (PolicyCheckerImpl.isJrtUrl(url)) {
            this.checkEntitlementPresent(callerClass, ReadJdkImageEntitlement.class);
        } else {
            this.checkUnsupportedURLProtocolConnection(callerClass, url.getProtocol());
        }
    }

    @Override
    public void checkEntitlementForURLConnection(Class<?> callerClass, URLConnection urlConnection) {
        if (PolicyCheckerImpl.isNetworkUrlConnection(urlConnection)) {
            this.checkOutboundNetworkAccess(callerClass);
        } else if (PolicyCheckerImpl.isFileUrlConnection(urlConnection)) {
            this.checkURLFileRead(callerClass, urlConnection.getURL());
        } else if (urlConnection instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
            this.checkJarURLAccess(callerClass, jarURLConnection);
        } else {
            this.checkUnsupportedURLProtocolConnection(callerClass, urlConnection.getURL().getProtocol());
        }
    }

    private URL extractJarFileUrl(URL jarUrl) {
        String spec = jarUrl.getFile();
        int separator = spec.indexOf("!/");
        if (separator == -1) {
            return null;
        }
        try {
            return new URL(spec.substring(0, separator));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private boolean handleNetworkOrFileUrlCheck(Class<?> callerClass, URL url) {
        if (PolicyCheckerImpl.isNetworkUrl(url)) {
            this.checkOutboundNetworkAccess(callerClass);
            return true;
        }
        if (PolicyCheckerImpl.isFileUrl(url)) {
            this.checkURLFileRead(callerClass, url);
            return true;
        }
        return false;
    }

    @Override
    public void checkJarURLAccess(Class<?> callerClass, JarURLConnection connection) {
        URL jarFileUrl = connection.getJarFileURL();
        if (this.handleNetworkOrFileUrlCheck(callerClass, jarFileUrl)) {
            return;
        }
        this.checkUnsupportedURLProtocolConnection(callerClass, jarFileUrl.getProtocol());
    }

    private static boolean isNetworkUrl(URL url) {
        return NETWORK_PROTOCOLS.contains(url.getProtocol());
    }

    private static boolean isFileUrl(URL url) {
        return "file".equals(url.getProtocol());
    }

    private static boolean isJarUrl(URL url) {
        return "jar".equals(url.getProtocol());
    }

    private static boolean isJrtUrl(URL url) {
        return "jrt".equals(url.getProtocol());
    }

    private static boolean isNetworkUrlConnection(URLConnection urlConnection) {
        Class<?> connectionClass = urlConnection.getClass();
        return HttpURLConnection.class.isAssignableFrom(connectionClass) || ADDITIONAL_NETWORK_URL_CONNECT_CLASS_NAMES.contains(connectionClass.getName());
    }

    private static boolean isFileUrlConnection(URLConnection urlConnection) {
        Class<?> connectionClass = urlConnection.getClass();
        return "sun.net.www.protocol.file.FileURLConnection".equals(connectionClass.getName());
    }

    @Override
    public void checkURLFileRead(Class<?> callerClass, URL url) {
        try {
            this.checkFileRead(callerClass, Paths.get(url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

