/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class XmlUtils {
    private static final Logger LOGGER = LogManager.getLogger(XmlUtils.class);

    public static DocumentBuilder getHardenedBuilder(String[] schemaFiles) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = XmlUtils.getHardenedBuilderFactory();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "file,jar");
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "file,jar");
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaFiles);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ErrorHandler());
        return documentBuilder;
    }

    @SuppressForbidden(reason="This is the only allowed way to construct a DocumentBuilder")
    public static DocumentBuilderFactory getHardenedBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setFeature("http://xml.org/sax/features/validation", true);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setIgnoringComments(true);
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        dbf.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setAttribute("http://apache.org/xml/features/validation/schema", true);
        dbf.setAttribute("http://apache.org/xml/features/validation/schema-full-checking", true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        return dbf;
    }

    @SuppressForbidden(reason="This is the only allowed way to construct a Transformer")
    public static Transformer getHardenedXMLTransformer() throws TransformerConfigurationException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        tfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        tfactory.setAttribute("indent-number", 2);
        Transformer transformer = tfactory.newTransformer();
        transformer.setErrorListener(new ErrorListener());
        return transformer;
    }

    @SuppressForbidden(reason="This is the only allowed way to construct a SchemaFactory")
    public static SchemaFactory getHardenedSchemaFactory() throws SAXNotSupportedException, SAXNotRecognizedException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return schemaFactory;
    }

    @SuppressForbidden(reason="This is the only allowed way to construct a Validator")
    public static Validator getHardenedValidator(Schema schema) throws SAXNotSupportedException, SAXNotRecognizedException {
        Validator validator = schema.newValidator();
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return validator;
    }

    @SuppressForbidden(reason="This is the only allowed way to construct a SAXParser")
    public static SAXParserFactory getHardenedSaxParserFactory() throws SAXNotSupportedException, SAXNotRecognizedException, ParserConfigurationException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        saxParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        saxParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return saxParserFactory;
    }

    @SuppressForbidden(reason="This is the only allowed way to construct an XPath")
    public static XPath getHardenedXPath() throws XPathFactoryConfigurationException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        xPathFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return xPathFactory.newXPath();
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private ErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            LOGGER.debug("XML Parser error ", (Throwable)e);
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            LOGGER.debug("XML Parser error ", (Throwable)e);
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            LOGGER.debug("XML Parser error ", (Throwable)e);
            throw e;
        }
    }

    private static class ErrorListener
    implements javax.xml.transform.ErrorListener {
        private ErrorListener() {
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
            LOGGER.debug("XML transformation error", (Throwable)e);
            throw e;
        }

        @Override
        public void error(TransformerException e) throws TransformerException {
            LOGGER.debug("XML transformation error", (Throwable)e);
            throw e;
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            LOGGER.debug("XML transformation error", (Throwable)e);
            throw e;
        }
    }
}

