/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.crossproject;

import java.util.Map;

public record ProjectTags(Map<String, String> tags) {
    public static final String PROJECT_ID_TAG = "_id";
    public static final String PROJECT_ALIAS = "_alias";
    public static final String PROJECT_TYPE_TAG = "_type";
    public static final String ORGANIZATION_ID_TAG = "_organization";

    public String projectId() {
        return this.tags.get(PROJECT_ID_TAG);
    }

    public String organizationId() {
        return this.tags.get(ORGANIZATION_ID_TAG);
    }

    public String projectType() {
        return this.tags.get(PROJECT_TYPE_TAG);
    }

    public String projectAlias() {
        return this.tags.get(PROJECT_ALIAS);
    }

    public static void validateTags(String projectId, Map<String, String> tags) {
        if (!tags.containsKey(PROJECT_ID_TAG)) {
            throw ProjectTags.missingTagException(projectId, PROJECT_ID_TAG);
        }
        if (!tags.containsKey(PROJECT_TYPE_TAG)) {
            throw ProjectTags.missingTagException(projectId, PROJECT_TYPE_TAG);
        }
        if (!tags.containsKey(ORGANIZATION_ID_TAG)) {
            throw ProjectTags.missingTagException(projectId, ORGANIZATION_ID_TAG);
        }
        if (!tags.containsKey(PROJECT_ALIAS)) {
            throw ProjectTags.missingTagException(projectId, PROJECT_ALIAS);
        }
    }

    private static IllegalStateException missingTagException(String projectId, String tagKey) {
        return new IllegalStateException("Project configuration for [" + projectId + "] is missing required tag [" + tagKey + "]");
    }
}

