/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.reflect;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.apache.lucene.codecs.lucene95.HasIndexSlice;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsWriter;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.elasticsearch.simdvec.QuantizedByteVectorValuesAccess;

public class VectorsFormatReflectionUtils {
    private static final VarHandle FLOAT_SUPPLIER_HANDLE;
    private static final VarHandle BYTE_SUPPLIER_HANDLE;
    private static final VarHandle FLOAT_VECTORS_HANDLE;
    private static final Class<?> FLAT_CLOSEABLE_RANDOM_VECTOR_SCORER_SUPPLIER_CLASS;
    private static final Class<?> SCALAR_QUANTIZED_CLOSEABLE_RANDOM_VECTOR_SCORER_SUPPLIER_CLASS;
    private static final Class<?> FLOAT_SCORING_SUPPLIER_CLASS;

    public static RandomVectorScorerSupplier getFlatRandomVectorScorerInnerSupplier(CloseableRandomVectorScorerSupplier scorerSupplier) {
        if (scorerSupplier.getClass().equals(FLAT_CLOSEABLE_RANDOM_VECTOR_SCORER_SUPPLIER_CLASS)) {
            return FLOAT_SUPPLIER_HANDLE.get(scorerSupplier);
        }
        return null;
    }

    public static RandomVectorScorerSupplier getScalarQuantizedRandomVectorScorerInnerSupplier(CloseableRandomVectorScorerSupplier scorerSupplier) {
        if (scorerSupplier.getClass().equals(SCALAR_QUANTIZED_CLOSEABLE_RANDOM_VECTOR_SCORER_SUPPLIER_CLASS)) {
            return BYTE_SUPPLIER_HANDLE.get(scorerSupplier);
        }
        return null;
    }

    public static HasIndexSlice getFloatScoringSupplierVectorOrNull(RandomVectorScorerSupplier scorerSupplier) {
        Object vectorValues;
        if (FLOAT_SCORING_SUPPLIER_CLASS.isAssignableFrom(scorerSupplier.getClass()) && (vectorValues = FLOAT_VECTORS_HANDLE.get(scorerSupplier)) instanceof HasIndexSlice) {
            HasIndexSlice indexSlice = (HasIndexSlice)vectorValues;
            return indexSlice;
        }
        return null;
    }

    public static HasIndexSlice getByteScoringSupplierVectorOrNull(RandomVectorScorerSupplier scorerSupplier) {
        if (scorerSupplier instanceof QuantizedByteVectorValuesAccess) {
            QuantizedByteVectorValuesAccess quantizedByteVectorValuesAccess = (QuantizedByteVectorValuesAccess)scorerSupplier;
            return quantizedByteVectorValuesAccess.get();
        }
        return null;
    }

    static {
        try {
            FLAT_CLOSEABLE_RANDOM_VECTOR_SCORER_SUPPLIER_CLASS = Class.forName("org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsWriter$FlatCloseableRandomVectorScorerSupplier");
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(FLAT_CLOSEABLE_RANDOM_VECTOR_SCORER_SUPPLIER_CLASS, MethodHandles.lookup());
            FLOAT_SUPPLIER_HANDLE = lookup.findVarHandle(FLAT_CLOSEABLE_RANDOM_VECTOR_SCORER_SUPPLIER_CLASS, "supplier", RandomVectorScorerSupplier.class);
            FLOAT_SCORING_SUPPLIER_CLASS = Class.forName("org.apache.lucene.internal.vectorization.Lucene99MemorySegmentFloatVectorScorerSupplier");
            lookup = MethodHandles.privateLookupIn(FLOAT_SCORING_SUPPLIER_CLASS, MethodHandles.lookup());
            FLOAT_VECTORS_HANDLE = lookup.findVarHandle(FLOAT_SCORING_SUPPLIER_CLASS, "values", FloatVectorValues.class);
            SCALAR_QUANTIZED_CLOSEABLE_RANDOM_VECTOR_SCORER_SUPPLIER_CLASS = Class.forName(Lucene99ScalarQuantizedVectorsWriter.class.getCanonicalName() + "$ScalarQuantizedCloseableRandomVectorScorerSupplier");
            lookup = MethodHandles.privateLookupIn(SCALAR_QUANTIZED_CLOSEABLE_RANDOM_VECTOR_SCORER_SUPPLIER_CLASS, MethodHandles.lookup());
            BYTE_SUPPLIER_HANDLE = lookup.findVarHandle(SCALAR_QUANTIZED_CLOSEABLE_RANDOM_VECTOR_SCORER_SUPPLIER_CLASS, "supplier", RandomVectorScorerSupplier.class);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("should not happen, check opens", e);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

