/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.action.support.replication.ReplicationRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.VersionType;

public class DeleteRequestBuilder
extends ReplicationRequestBuilder<DeleteRequest, DeleteResponse, DeleteRequestBuilder>
implements WriteRequestBuilder<DeleteRequestBuilder> {
    private String id;
    private String routing;
    private Long version;
    private VersionType versionType;
    private Long seqNo;
    private Long term;
    private WriteRequest.RefreshPolicy refreshPolicy;

    public DeleteRequestBuilder(ElasticsearchClient client, @Nullable String index) {
        super(client, TransportDeleteAction.TYPE);
        this.setIndex(index);
    }

    public DeleteRequestBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public DeleteRequestBuilder setRouting(String routing) {
        this.routing = routing;
        return this;
    }

    public DeleteRequestBuilder setVersion(long version) {
        this.version = version;
        return this;
    }

    public DeleteRequestBuilder setVersionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public DeleteRequestBuilder setIfSeqNo(long seqNo) {
        this.seqNo = seqNo;
        return this;
    }

    public DeleteRequestBuilder setIfPrimaryTerm(long term) {
        this.term = term;
        return this;
    }

    @Override
    public DeleteRequestBuilder setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public DeleteRequestBuilder setRefreshPolicy(String refreshPolicy) {
        this.refreshPolicy = WriteRequest.RefreshPolicy.parse(refreshPolicy);
        return this;
    }

    @Override
    public DeleteRequest request() {
        DeleteRequest request = new DeleteRequest();
        super.apply(request);
        if (this.id != null) {
            request.id(this.id);
        }
        if (this.routing != null) {
            request.routing(this.routing);
        }
        if (this.version != null) {
            request.version(this.version);
        }
        if (this.versionType != null) {
            request.versionType(this.versionType);
        }
        if (this.seqNo != null) {
            request.setIfSeqNo(this.seqNo);
        }
        if (this.term != null) {
            request.setIfPrimaryTerm(this.term);
        }
        if (this.refreshPolicy != null) {
            request.setRefreshPolicy(this.refreshPolicy);
        }
        return request;
    }
}

