/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.recovery.RecoveryRequest;
import org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportRecoveryAction
extends TransportBroadcastByNodeAction<RecoveryRequest, RecoveryResponse, RecoveryState> {
    private final IndicesService indicesService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportRecoveryAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ProjectResolver projectResolver) {
        super("indices:monitor/recovery", clusterService, transportService, actionFilters, indexNameExpressionResolver, RecoveryRequest::new, transportService.getThreadPool().executor("management"));
        this.indicesService = indicesService;
        this.projectResolver = projectResolver;
    }

    @Override
    protected RecoveryState readShardResult(StreamInput in) throws IOException {
        return RecoveryState.readRecoveryState(in);
    }

    @Override
    protected TransportBroadcastByNodeAction.ResponseFactory<RecoveryResponse, RecoveryState> getResponseFactory(RecoveryRequest request, ClusterState clusterState) {
        return (totalShards, successfulShards, failedShards, responses, shardFailures) -> {
            HashMap<String, List<RecoveryState>> shardResponses = new HashMap<String, List<RecoveryState>>();
            for (RecoveryState recoveryState : responses) {
                if (recoveryState == null) continue;
                String indexName = recoveryState.getShardId().getIndexName();
                if (!shardResponses.containsKey(indexName)) {
                    shardResponses.put(indexName, new ArrayList());
                }
                if (request.activeOnly()) {
                    if (recoveryState.getStage() == RecoveryState.Stage.DONE) continue;
                    ((List)shardResponses.get(indexName)).add(recoveryState);
                    continue;
                }
                ((List)shardResponses.get(indexName)).add(recoveryState);
            }
            return new RecoveryResponse(totalShards, successfulShards, failedShards, shardResponses, shardFailures);
        };
    }

    @Override
    protected RecoveryRequest readRequestFrom(StreamInput in) throws IOException {
        return new RecoveryRequest(in);
    }

    @Override
    protected void shardOperation(RecoveryRequest request, ShardRouting shardRouting, Task task, ActionListener<RecoveryState> listener) {
        ActionListener.completeWith(listener, () -> {
            assert (task instanceof CancellableTask);
            IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
            IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
            return indexShard.recoveryState();
        });
    }

    @Override
    protected ShardsIterator shards(ClusterState state, RecoveryRequest request, String[] concreteIndices) {
        return state.routingTable(this.projectResolver.getProjectId()).allShardsIncludingRelocationTargets(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, RecoveryRequest request) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, RecoveryRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_READ, concreteIndices);
    }
}

