/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.get;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadProjectAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.ResolvedRepositories;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetRepositoriesAction
extends TransportMasterNodeReadProjectAction<GetRepositoriesRequest, GetRepositoriesResponse> {
    @Inject
    public TransportGetRepositoriesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super("cluster:admin/repository/get", transportService, clusterService, threadPool, actionFilters, GetRepositoriesRequest::new, projectResolver, GetRepositoriesResponse::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    @Override
    protected ClusterBlockException checkBlock(GetRepositoriesRequest request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(Task task, GetRepositoriesRequest request, ProjectState state, ActionListener<GetRepositoriesResponse> listener) {
        ResolvedRepositories result = ResolvedRepositories.resolve(state.metadata(), request.repositories());
        if (result.hasMissingRepositories()) {
            listener.onFailure(new RepositoryMissingException(String.join((CharSequence)", ", result.missing())));
        } else {
            listener.onResponse(new GetRepositoriesResponse(new RepositoriesMetadata(result.repositoryMetadata())));
        }
    }
}

