/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.gpu;

import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.GPUInfo;
import com.nvidia.cuvs.GPUInfoProvider;
import com.nvidia.cuvs.spi.CuVSProvider;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class GPUSupport {
    private static final Logger LOG = LogManager.getLogger(GPUSupport.class);
    private static final long MIN_DEVICE_MEMORY_IN_BYTES = 0x1E0000000L;

    public static boolean isSupported(boolean logError) {
        block11: {
            try {
                GPUInfoProvider gpuInfoProvider = CuVSProvider.provider().gpuInfoProvider();
                List availableGPUs = gpuInfoProvider.availableGPUs();
                if (availableGPUs.isEmpty()) {
                    if (logError) {
                        LOG.warn("No GPU found");
                    }
                    return false;
                }
                for (GPUInfo gpu : availableGPUs) {
                    if (gpu.computeCapabilityMajor() < 7 || gpu.computeCapabilityMajor() == 7 && gpu.computeCapabilityMinor() < 0) {
                        if (!logError) continue;
                        LOG.warn("GPU [{}] does not have the minimum compute capabilities (required: [{}.{}], found: [{}.{}])", new Object[]{gpu.name(), 7, 0, gpu.computeCapabilityMajor(), gpu.computeCapabilityMinor()});
                        continue;
                    }
                    if (gpu.totalDeviceMemoryInBytes() < 0x1E0000000L) {
                        if (!logError) continue;
                        LOG.warn("GPU [{}] does not have minimum memory required (required: [{}], found: [{}])", new Object[]{gpu.name(), 0x1E0000000L, gpu.totalDeviceMemoryInBytes()});
                        continue;
                    }
                    if (logError) {
                        LOG.info("Found compatible GPU [{}] (id: [{}])", new Object[]{gpu.name(), gpu.gpuId()});
                    }
                    return true;
                }
            }
            catch (UnsupportedOperationException uoe) {
                if (logError) {
                    String msg = uoe.getMessage() == null ? Strings.format((String)"runtime Java version [%d], OS [%s], arch [%s]", (Object[])new Object[]{Runtime.version().feature(), System.getProperty("os.name"), System.getProperty("os.arch")}) : uoe.getMessage();
                    LOG.warn("GPU based vector indexing is not supported on this platform; " + msg);
                }
            }
            catch (Throwable t) {
                if (!logError) break block11;
                if (t instanceof ExceptionInInitializerError) {
                    ExceptionInInitializerError ex = (ExceptionInInitializerError)t;
                    t = ex.getCause();
                }
                LOG.warn("Exception occurred during creation of cuvs resources", t);
            }
        }
        return false;
    }

    public static CuVSResources cuVSResourcesOrNull(boolean logError) {
        block5: {
            try {
                CuVSResources resources = CuVSResources.create();
                return resources;
            }
            catch (UnsupportedOperationException uoe) {
                if (logError) {
                    Object msg = "";
                    msg = uoe.getMessage() == null ? "Runtime Java version: " + Runtime.version().feature() : ": " + uoe.getMessage();
                    LOG.warn("GPU based vector indexing is not supported on this platform or java version; " + (String)msg);
                }
            }
            catch (Throwable t) {
                if (!logError) break block5;
                if (t instanceof ExceptionInInitializerError) {
                    ExceptionInInitializerError ex = (ExceptionInInitializerError)t;
                    t = ex.getCause();
                }
                LOG.warn("Exception occurred during creation of cuvs resources", t);
            }
        }
        return null;
    }
}

