/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CagraIndexParams;
import java.util.Objects;

public final class TieredIndexParams {
    private final Metric metric;
    private final int minAnnRows;
    private final boolean createAnnIndexOnExtend;
    private final CagraIndexParams cagraParams;

    private TieredIndexParams(Builder builder) {
        this.metric = builder.metric;
        this.minAnnRows = builder.minAnnRows;
        this.createAnnIndexOnExtend = builder.createAnnIndexOnExtend;
        this.cagraParams = builder.cagraParams;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public int getMinAnnRows() {
        return this.minAnnRows;
    }

    public boolean isCreateAnnIndexOnExtend() {
        return this.createAnnIndexOnExtend;
    }

    public CagraIndexParams getCagraParams() {
        return this.cagraParams;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Metric metric = Metric.L2;
        private int minAnnRows = 4096;
        private boolean createAnnIndexOnExtend = true;
        private CagraIndexParams cagraParams = null;

        public Builder metric(Metric metric) {
            this.metric = Objects.requireNonNull(metric);
            return this;
        }

        public Builder minAnnRows(int minAnnRows) {
            if (minAnnRows <= 0) {
                throw new IllegalArgumentException("minAnnRows must be positive, got: " + minAnnRows);
            }
            this.minAnnRows = minAnnRows;
            return this;
        }

        public Builder createAnnIndexOnExtend(boolean val) {
            this.createAnnIndexOnExtend = val;
            return this;
        }

        public Builder withCagraParams(CagraIndexParams params2) {
            this.cagraParams = Objects.requireNonNull(params2);
            return this;
        }

        public TieredIndexParams build() {
            if (this.cagraParams == null) {
                throw new IllegalStateException("CAGRA params required");
            }
            return new TieredIndexParams(this);
        }
    }

    public static enum Metric {
        L2,
        INNER_PRODUCT;

    }
}

