/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

public record HnswSearchParams(int ef, int numThreads) {
    public HnswSearchParams {
        if (ef < 0) {
            throw new IllegalArgumentException();
        }
        if (numThreads < 0) {
            throw new IllegalArgumentException();
        }
    }

    public static class Builder {
        private static final int DEFAULT_EF_VALUE = 200;
        private static final int DEFAULT_NUM_THREADS = 0;
        private int ef = 200;
        private int numThreads = 0;

        public Builder withEF(int ef) {
            this.ef = ef;
            return this;
        }

        public Builder withNumThreads(int numThreads) {
            this.numThreads = numThreads;
            return this;
        }

        public HnswSearchParams build() {
            return new HnswSearchParams(this.ef, this.numThreads);
        }
    }
}

