/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.spi;

import com.nvidia.cuvs.internal.common.NativeLibraryUtils;
import com.nvidia.cuvs.spi.JDKProvider;
import com.nvidia.cuvs.spi.ProviderInitializationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

class NativeDependencyLoader {
    private static final NativeDependencyLoaderStrategy LOADER_STRATEGY = NativeDependencyLoader.createLoaderStrategy();
    private static boolean loaded = false;

    NativeDependencyLoader() {
    }

    private static NativeDependencyLoaderStrategy createLoaderStrategy() {
        if (NativeDependencyLoader.jarHasNativeDependencies()) {
            return new EmbeddedNativeDependencyLoaderStrategy();
        }
        return new SystemNativeDependencyLoaderStrategy();
    }

    private static boolean jarHasNativeDependencies() {
        boolean bl;
        JarFile jarFile = new JarFile(JDKProvider.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        try {
            Manifest manifest = jarFile.getManifest();
            String embeddedLibrariesCudaVersion = manifest.getMainAttributes().getValue("Embedded-Libraries-Cuda-Version");
            bl = embeddedLibrariesCudaVersion != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    static void loadLibraries() throws ProviderInitializationException {
        if (!loaded) {
            try {
                LOADER_STRATEGY.loadLibraries();
            }
            finally {
                loaded = true;
            }
        }
    }

    private static class EmbeddedNativeDependencyLoaderStrategy
    implements NativeDependencyLoaderStrategy {
        private static final String OS = System.getProperty("os.name");
        private static final String ARCH = System.getProperty("os.arch");
        private static final ClassLoader CLASS_LOADER = JDKProvider.class.getClassLoader();
        private static final String[] FILES_TO_LOAD = new String[]{"rapids_logger", "rmm", "cuvs", "cuvs_c"};

        private EmbeddedNativeDependencyLoaderStrategy() {
        }

        @Override
        public void loadLibraries() throws ProviderInitializationException {
            for (String file : FILES_TO_LOAD) {
                try {
                    System.load(EmbeddedNativeDependencyLoaderStrategy.createFile(file).getAbsolutePath());
                }
                catch (Throwable t) {
                    throw new ProviderInitializationException("Failed to load native dependency: " + System.mapLibraryName(file) + ".so: " + t.getMessage(), t);
                }
            }
        }

        private static File createFile(String baseName) throws IOException {
            File loc;
            String path = ARCH + "/" + OS + "/" + System.mapLibraryName(baseName);
            URL resource = CLASS_LOADER.getResource(path);
            if (resource == null) {
                throw new FileNotFoundException("Could not locate native dependency " + path);
            }
            try (InputStream in = resource.openStream();){
                loc = File.createTempFile(baseName, ".so");
                loc.deleteOnExit();
                Files.copy(in, loc.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            return loc;
        }
    }

    private static class SystemNativeDependencyLoaderStrategy
    implements NativeDependencyLoaderStrategy {
        private SystemNativeDependencyLoaderStrategy() {
        }

        @Override
        public void loadLibraries() throws ProviderInitializationException {
            Object lib;
            String cuvsLibraryName = System.mapLibraryName("cuvs_c");
            try (Arena localArena = Arena.ofConfined();){
                MemorySegment name = localArena.allocateFrom(cuvsLibraryName);
                lib = NativeLibraryUtils.JVM_LoadLibrary$mh.invoke(name, true);
            }
            catch (Throwable ex) {
                if (ex instanceof UnsatisfiedLinkError) {
                    UnsatisfiedLinkError ulex = (UnsatisfiedLinkError)ex;
                    throw new ProviderInitializationException(ulex.getMessage(), ulex);
                }
                throw new ProviderInitializationException("Error while loading " + cuvsLibraryName, ex);
            }
            if (lib == null) {
                throw new ProviderInitializationException("Unspecified failure loading " + cuvsLibraryName);
            }
        }
    }

    static interface NativeDependencyLoaderStrategy {
        public void loadLibraries() throws ProviderInitializationException;
    }
}

