/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.type;

import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;

public class TextEsField
extends EsField {
    private Function<Tuple<EsField, String>, EsField.Exact> PROCESS_EXACT_FIELD = tuple -> {
        if (tuple.v1() == null) {
            return new EsField.Exact(false, (String)tuple.v2());
        }
        return new EsField.Exact(true, null);
    };

    public TextEsField(String name, Map<String, EsField> properties, boolean hasDocValues) {
        this(name, properties, hasDocValues, false);
    }

    public TextEsField(String name, Map<String, EsField> properties, boolean hasDocValues, boolean isAlias) {
        super(name, DataTypes.TEXT, properties, hasDocValues, isAlias);
    }

    @Override
    public EsField getExactField() {
        Tuple<EsField, String> findExact = this.findExact();
        if (findExact.v1() == null) {
            throw new QlIllegalArgumentException((String)findExact.v2());
        }
        return (EsField)findExact.v1();
    }

    @Override
    public EsField.Exact getExactInfo() {
        return this.PROCESS_EXACT_FIELD.apply(this.findExact());
    }

    private Tuple<EsField, String> findExact() {
        EsField field = null;
        for (EsField property : this.getProperties().values()) {
            if (property.getDataType() != DataTypes.KEYWORD || !property.getExactInfo().hasExact()) continue;
            if (field != null) {
                return new Tuple(null, (Object)("Multiple exact keyword candidates available for [" + this.getName() + "]; specify which one to use"));
            }
            field = property;
        }
        if (field == null) {
            return new Tuple(null, (Object)("No keyword/multi-field defined exact matches for [" + this.getName() + "]; define one or use MATCH/QUERY instead"));
        }
        return new Tuple(field, null);
    }
}

