/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.pipeline;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.processor.ChainingProcessor;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public final class UnaryPipe
extends Pipe {
    private final Pipe child;
    private final Processor action;

    public UnaryPipe(Source source, Expression expression, Pipe child, Processor action) {
        super(source, expression, Collections.singletonList(child));
        this.child = child;
        this.action = action;
    }

    @Override
    protected NodeInfo<UnaryPipe> info() {
        return NodeInfo.create(this, UnaryPipe::new, this.expression(), this.child, this.action);
    }

    @Override
    public Pipe replaceChildren(List<Pipe> newChildren) {
        return new UnaryPipe(this.source(), this.expression(), newChildren.get(0), this.action);
    }

    public Pipe child() {
        return this.child;
    }

    public Processor action() {
        return this.action;
    }

    @Override
    public boolean resolved() {
        return this.child.resolved();
    }

    @Override
    public Processor asProcessor() {
        return new ChainingProcessor(this.child.asProcessor(), this.action);
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.child.supportedByAggsOnlyQuery();
    }

    @Override
    public Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newChild = this.child.resolveAttributes(resolver);
        if (newChild == this.child) {
            return this;
        }
        return new UnaryPipe(this.source(), this.expression(), newChild, this.action);
    }

    @Override
    public void collectFields(QlSourceBuilder sourceBuilder) {
        this.child.collectFields(sourceBuilder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression(), this.child, this.action);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryPipe other = (UnaryPipe)obj;
        return Objects.equals(this.action, other.action) && Objects.equals(this.child, other.child) && Objects.equals(this.expression(), other.expression());
    }
}

